# Wordpress

## Basic

### To install

-   You only have to download the source code and extract it into the
    chosen folder, the web server must have permissions to write on it.
-   You have to create a data base on the MySql server for Wordpress.
    When you access to it on the first time, the webpage will show you
    the installer; you will have to introduce the data.

### Directory structure

-   Root directory. The only useful file is wp-config.php.
-   wp-content. Contain plugins, themes, and uploaded files.
    -   wp-content/plugins. Plugins.
    -   wp-content/themes. Installed themes.
    -   wp-content/uploads. Uploaded media.
    -   wp-content/mu-plugins. This directory doesn\'t exist unless you
        create it. Mu means must use. Any plugin you put here will be
        automatically run without needing to activate it.
-   wp-admin. To manage the admin.
-   wp-inludes. Core directory.

### How to develop

Core code files implement main Wordpress functions.
/wp-includes/option.php, for example, contains functions for updating
the site configuration, /wp-includes/pluggable.php and /wp-includes/
user.php contain function for updating users\... Also exist
/wp-includes/post.php, comments\...

There is also the possibility to add more information to these elements
(posts, users, comments\...); to do that exists the concept of meta
elements, which exists for other main elements in Wordpress.

### Themes and plugins

### Links

-   [Plugins handbook](https://developer.wordpress.org/plugins/)
-   [Themes
    handbook](https://developer.wordpress.org/themes/getting-started/who-should-read-this-handbook/)

## Themes

`wp-content\themes` contains several folders, each one is an installed
theme. You can develop your theme there.\
WordPress themes only require two files: index.php and style.css. They
usually are made up of many files and can become quickly disorganized.
Still Wordpress does not need any folder you also can add a js and a css
folders, in its root you\'ll place the template main files. There\'s
also another especial folder, page-templates, where you will put the
custom page template files.\

So, to develop a theme you will create a folder with the name of the
theme. There you will add an index.php file and a style.css.

### Theme hierarchy

WordPress uses the query string (a sequence of codes in a Uniform
Resource Identifier (URI) that a web page uses to determine what dynamic
data to display) to decide which template or set of templates should be
used to display the page.

1.  From the query string Wordpress decides which page is being
    requested (search, category\...).
2.  Selects the template determined by the template hierarchy.
3.  Looks for template files with specific names in the current theme's
    directory and uses the first matching template file as specified by
    the hierarchy.

With the exception of the basic index.php template file, you can choose
whether you want to implement a particular template file or not. If
WordPress cannot find a template file with a matching name, it will skip
to the next file in the hierarchy. If WordPress cannot find any matching
template file, the theme's index.php file will be used.

-   Home Page (home.php \| index.php). By default, WordPress sets your
    site's home page to display your latest blog posts. This page is
    called the Blog Posts Index. The template file home.php is used to
    render the blog posts index, whether it is being used as the front
    page or on separate static page. If the home.php file does not
    exist, WordPress will use the index.php file. If the front-page.php
    file exists, it will override the home.php file.
-   Front Page (font-page.php \| home.php \| page.php \| index.php). The
    front-page.php template file is used to render your site's Front
    Page, whether the front page displays the blog posts index or a
    static page.
-   Single post (single-{post-type}.php \| single.php \| index.php).
    Template file used to render a single post.
-   Page (custom template file \| page-slug.php \| page-id.php \|
    index.php). The template file used to render a static page (page
    post-type).
-   Category.
-   Tags
-   Custom taxonomies.
-   Custom post types.
-   Author display.
-   Date.
-   Search Result.
-   404 not found.
-   Attachment.

### functions.php

To add some logic to the template. The difference between functions.php
and plugin.

A WordPress plugin:

-   Requires specific, unique header text
-   Is stored in wp-content/plugins, usually in a subdirectory
-   Only executes on page load when activated
-   Applies to all themes
-   Should have a single purpose, e.g., convert Posts to Pages, offer
    search engine optimization features, or help with backups

A functions file:

-   Requires no unique header text
-   Is stored in theme's subdirectory in wp-content/themes
-   Executes only when in the active theme's directory
-   Applies only to that theme. If the theme is changed, the
    functionality is lost can have numerous blocks of code used for many
    different purposes

In functions.php you can:

-   Use WordPress hooks. For example, with the excerpt_length filter you
    can change your post excerpt length (from default of 55 words).
-   Enable WordPress features with add_theme_support() to turn on post
    thumbnails, post formats, and navigation menus.
-   Define functions you wish to reuse in multiple theme template files.

functions.php is loaded during theme setup, after any plugin files have
loaded.

General uses for functions.php:

-   Theme Setup
-   Initial Setup
-   Automatic Feed Links
-   Navigation Menus
-   Load Text Domain
-   Post Thumbnails (to allow thumbnail images in posts)
-   Post Formats
-   Sidebars
-   Custom header (to allow the user to use their own image)
-   Custom background
-   Add editor style
-   Content width

![This is an example of
functions.php](/wiki2/wordpress/example_functions_php.txt)

### Attaching CSS and JS

You will need to register and enqueue the plugins and styles. To do it,
you must add a callback function to the head or the `wp_enqueue_scripts`
event. To add it:

``` php
add_action( 'wp_enqueue_scripts', 'register_styles' );
```

Then, to register and enqueue:

``` php
function register_styles() {
    wp_register_style( 'my-plugin',  get_template_directory_uri() . '/css/my_style.css' );
    wp_enqueue_style( 'my-plugin' );
}

```

All of this code goes into the functions.php.

You also can use `plugins_url()`(for Plugins) and
`get_template_directory_uri()` (for Themes) to get a proper URL.

In the same way you will use `wp_register_script` and
`wp_enqueue_style`.

### Page templates

Special wordpress templates. They are only to change the look and feel
of a page (not a post); they can be applied to a single page, a page
section or a class of pages. page-about.php is a page template, more
specific than page.php or index.php.

When a user requests a specific page, the core WordPress code decides
which template to use for rendering that page. Template Hierarchy:

-   Page Template --- If the page has a custom template assigned,
    WordPress looks for that file and, if found, uses it.
-   page-{slug}.php --- Or else WordPress looks for and, if found, uses
    a specialized template named with the page's slug.
-   page-{id}.php --- Or else WordPress looks for and, if found, uses a
    specialized template named with the page's ID.
-   page.php --- Or else WordPress looks for and, if found, uses the
    theme's default page template.

index.php --- Or else WordPress uses the theme's index file.

Name your template file so you can easily identify its template name,
e.g., filename my-custom-page.php for the template name "My Custom
Page." Important! Do not use page- as a prefix, as WordPress will
interpret the file as a specialized template, meant to apply to only one
page on your site.

For example: Your About page has a slug of 'about' and an ID of 6. If
your active theme's folder has a file named page-about.php or
page-6.php, then WordPress will automatically find and use that file to
render the About page.

### The post loop

It\'s used to display posts according to your instructions given by
template tags. The basic loop is (while there are posts, display the
posts):

``` php
<?php if (have_posts()) : ?>
<?php while (have_posts()) : the_post(); ?>
```

The most simple index.php would be:

``` php
<?php
get_header();
if (have_posts()) :
   while (have_posts()) :
      the_post();
      the_content();
   endwhile;
endif;
get_sidebar();
get_footer();
?>
```

Other example:

``` php
<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
<h2><?php the_title(); ?></h2>
 
    <?php the_post_thumbnail(); ?>
    <?php the_excerpt(); ?>
 
<?php endwhile; else: ?>
<?php _e('Sorry, no posts matched your criteria.'); ?>
<?php endif; ?>
```

#### Functions that cna be used

-   <https://developer.wordpress.org/themes/basics/the-loop/#what-the-loop-can-display>

#### WP_Query

-   <https://developer.wordpress.org/reference/classes/wp_query/>

WP_Query is a class given by WordPress to be used in the loop. For
example `$wp_query->have_posts()` is called to see if there are any
posts to show. To obtain a post \$`wp_query->the_post()` is called. Also
can be used to filter posts:

``` php
<?php $my_query = new WP_Query( $args ); ?>
<?php while ($my_query->have_posts()) ? $my_query->the_post(); ?>
    // Do something
<?php endwhile; ?>
```

### Conditional tags

They are used o control which templates are loaded on a certain page.
Also which parts:

-   <https://developer.wordpress.org/themes/basics/conditional-tags/>

### Useful functions to use on templates

-   `wp_head()`, put it before `</head>` and wordpress will add required
    code for plugins.
-   `get_footer()` includes the footer.php template file. `get_header()`
    includes the header.php template file. `get_sidebar()` includes the
    sidebar.php. Customized versions of these files can be called as
    well by naming the file sidebar-{your_custom_template}.php\... You
    can then call the get\_\* functions with the custom template name as
    the only parameter, like this:
    `get_header( 'your_custom_template' );`.
-   `get_template_directory_uri();` & `get_stylesheet_directory_uri();`
-   Conditional functions: `is_user_logged_in()`, `is_home()`,
    `is_front_page()`, `is_admin()`\...
-   [Other functions to ask the
    template](https://developer.wordpress.org/themes/basics/conditional-tags/)
-   `bloginfo('name');` to obtain information about the blog. Possible
    parameters: name, description, charset.
-   `the_title();`

### How to\...

#### Simple header

``` php
 <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <title><?php wp_title( '|', true, 'right' ); ?></title>
        <link rel="stylesheet" href="<?php echo esc_url( get_stylesheet_uri() ); ?>" type="text/css" />
<?php wp_head(); ?>
    </head>
```

#### Create a front pate

You must indicate on the admin panel that the front page won\'t show the
first post but content from a created page. Then\...

``` php
<?php
/*
* Template Name: My Template
*/
get_header(); ?>

<div id="container">
    <div id="content" class="pageContent">

    <h1 class="entry-title"><?php the_title(); ?></h1> <!-- Page Title -->
    <?php
    // TO SHOW THE PAGE CONTENTS
    while ( have_posts() ) : the_post(); ?> <!--Because the_content() works only inside a WP Loop -->
        <div class="entry-content-page">
            <?php the_content(); ?> <!-- Page Content -->
        </div><!-- .entry-content-page -->

    <?php
    endwhile; //resetting the page loop
    wp_reset_query(); //resetting the page query
    ?>

    <?php
    // TO SHOW THE POST CONTENTS
    ?>                        
        <?php
        $my_query = new WP_Query( 'cat=1' ); // I used a category id 1 as an example
        ?>
        <?php if ( $my_query->have_posts() ) : ?>
        <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
        <?php while ($my_query->have_posts()) : $my_query->the_post(); ?>

            <h1 class="entry-title"><?php the_title(); ?></h1> <!-- Queried Post Title -->
            <div class="entry-content">
                <?php the_excerpt(); ?> <!-- Queried Post Excerpts -->
            </div><!-- .entry-content -->

        <?php endwhile; //resetting the post loop ?>

        </div><!-- #post-<?php the_ID(); ?> -->

        <?php
        wp_reset_postdata(); //resetting the post query
        endif;
        ?>

    </div><!-- #content -->         
</div><!-- #container -->
```

#### Get all posts

Using the argument post_status=any and post_per_page=1:

``` php
$args = array(
              'post_type' => 'post',
              'orderby'   => 'title',
              'order'     => 'ASC',
              'post_status' => 'any',
              'posts_per_page' => -1,
            );
$my_query = new WP_Query($args);
```

#### Get a concrete page content

``` php
<?php $the_query = new WP_Query( 'pagename=contact' ); ?>
<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
<h2><?php the_title(); ?></h2>
<?php the_content(); ?>
<?php endwhile; ?>
<?php wp_reset_postdata(); ?>
```

#### Get child pages from front page

First you must obtain the ID of the front page, it\'s stored in the
wp_options WP table, as option_name=page_on_front and option_value=ID of
the page. So if you want to retrieve this value, just use
get_option(\'page_on_front\').

``` php
<?php $args = array(
    'child_of'     => get_option('page_on_front'),
    'post_type'    => 'page',
    'post_status'  => 'publish',
    'title_li'     => '', 
); ?>
<?php $children = wp_list_pages( $args ); ?>
<?php if ($children) : ?>
<ul>
<?php echo   $children; ?>
</ul>
<?php endif; ?>
```

### Other functionalities

-   [Post thumbnails](http://codex.wordpress.org/Post_Thumbnails)
-   [Custom headers](http://codex.wordpress.org/Custom_Headers)

## Plugins
