# Web development tools

## Node

### Install module & save it as dependence

    $ npm install <module> --save

### Install module & save it as a dev dependence

    $ npm install <module> --save-dev

## Gulp

### Basic script (gulpfile.js)

    var gulp = require('gulp');

    gulp.task('default', function() {
      // place code for your default task here
    });

Execute it:

    $ gulp

If there was not a `default` but, for ex., `deploy`:

    $ gulp deploy

### Indicate src and dest folders

    var gulp = require('gulp')

    gulp.task('deploy', function () {
        return gulp.src('app/*.js')
            .pipe(gulp.dest('dist'));
    });

:!: remember to return so there was another task which depended of this
could use it

### Add another command to execute prior to the current

    gulp.task('deploy', ['prior-task1', 'prior-task2'], function () { ...

## Tools for web development

### Automatically reload static pages

-   <https://www.npmjs.com/package/reload>

With reload installed you can do `reload -b` into your root path an it
will automatically reload when some of its inner files change.

### Emmet

#### Forms

    form>input[type=text]+input[type=password]+submit

    <form>
        <input type="text">
        <input type="password">
        <submit></submit>
    </form>

## Tips and notes

### Test external authenticator

You have to prepare one of your servers to accept a connection from the
authenticator.

For example, in Caddy:

    fok.surrealistic.xyz {
        proxy / localhost:8000
        header / Strict-Transport-Security "15768000"
    }

Or in Nginx:

Then you configure the authenticator to your url:
`https://fok.surrealistic.xyz/login`

And add a tunnel to your server from your machine on the chosen port:

    ssh -R "0.0.0.0:8000:0.0.0.0:8000" codi
