# Vue2 Old

## Create a project

    $ vue init webpack vueapp01

## Controller example

    <template>
      <div class="hello">
      <h1>{{ msg }}</h1>
        <hr />
        <div>
          <ul>
            <li v-for="user in users" :key="user.name">
              {{user.firstname}} {{user.lastname}}
            </li>
          </ul>
        </div>
        <hr />
        <div>
          <input type="text" v-model="input_val">
        </div>
        <div>
          Input Value: <span v-text="input_val"></span>
        </div>
        <hr />
        <div>
          <button class="btn btn-primary" v-on:click="counter++">You've clicked this button {{counter}} times!</button>
        </div>
      </div>
    </template>

    <script>
    export default {
      name: 'HelloWorld',
      data () {
        return {
          msg: 'Welcome to Your Vue.js App',
          users: [
            {firstname: 'Sebastian', lastname: 'Eschweiler'},
            {firstname: 'Bill', lastname: 'Smith'},
            {firstname: 'John', lastname: 'Porter'}
          ],
          input_val: '',
          counter: 0
        }
      }
    }
    </script>

    <!-- Add "scoped" attribute to limit CSS to this component only -->
    <style scoped>
    h1, h2 {
      font-weight: normal;
    }
    ul {
      list-style-type: none;
      padding: 0;
    }
    li {
      display: inline-block;
      margin: 0 10px;
    }
    a {
      color: #42b983;
    }
    </style>

## Little

### V-For and V-Bind with :

            <li v-for="bk in bookmarks" :key="bk.id">
              <a :href="bk.url" v-text="bk.title"></a>
            </li>

### Component constructor

    import axios from 'axios'

    export default {
      name: 'Bookmarks',
      data () {
        return {
          msg: 'Welcome to Your Vue.js App',
          bookmarks: [],
          input_val: '',
          counter: 0
        }
      },
      methods: {
      },
      created: function () {
        axios.get('http://localhost:3000/bookmarks')
          .then(response => {
            this.bookmarks = response.data
          })
      }
    }

## Other

### Axios

-   <https://alligator.io/vuejs/rest-api-axios/>

```{=html}
<!-- -->
```
    import axios from 'axios'

    export default {
      name: 'Bookmarks',
      data () {
        return {
          msg: 'Welcome to Your Vue.js App',
          bookmarks: [],
          input_val: '',
          counter: 0
        }
      },
      methods: {
      },
      created: function () {
        axios.get('http://localhost:3000/bookmarks')
          .then(response => {
            this.bookmarks = response.data
          })
      }
    }
