# Vim Configuration

The `.vimrc` file on your home folder is the vim configuration file.
However you can use the next `.vim` folder structure, also in the home
folder:

    .vim
      |__vimrc    # configuration file 
      |__after/    # for overrides to system-level vim
      |__autoload/ # a directory for some plugins
      |__colors/   # custom colorthemes
      |__doc/      # documentation
      |__ftplugin/ # custom filetype plugins
      |__indent/   # custom indentation overrides
      |__plugin/   # plugin installation directory
      |__syntax/   # custom syntax coloring files

## Plugin managers

### Pathogen

    mkdir -p ~/.vim/autoload ~/.vim/bundle && \
    curl -LSso ~/.vim/autoload/pathogen.vim https://tpo.pe/pathogen.vim

Recuerda con proxy: `curl http_proxy=...`

## Notes

### Improve performance

If vim goes too slow do: `:syntax off`.

You can also try other terminal emulators like Alacritty, Tilda, Kitty,
iTerm, Terminal or Hyper.
