# TypeScript

## Basics

### Foreach

``` javascript
for (var item of someArray) {
    console.log(item); // 9,2,5
}
```

### Functions with return type

``` javascript
greet() : string {
    return "Hello!";
}
```

### Getters

``` javascript
get whereSendContent () {
    return `${AppConfig.ServerUrl}'/content`;
}
```

## Classes

### Inheritance

``` javascript
class Animal {
    name: string;
    constructor(theName: string) { this.name = theName; }
    move(distanceInMeters: number = 0) {
        console.log(`${this.name} moved ${distanceInMeters}m.`);
    }
}

class Snake extends Animal {
    constructor(name: string) { super(name); }
    move(distanceInMeters = 5) {
        console.log("Slithering...");
        super.move(distanceInMeters);
    }
}

class Horse extends Animal {
    constructor(name: string) { super(name); }
    move(distanceInMeters = 45) {
        console.log("Galloping...");
        super.move(distanceInMeters);
    }
}

let sam = new Snake("Sammy the Python");
let tom: Animal = new Horse("Tommy the Palomino");

sam.move();
tom.move(34);
```

### Static properties

``` javascript
class Grid {
    static origin = {x: 0, y: 0};
    calculateDistanceFromOrigin(point: {x: number; y: number;}) {
        let xDist = (point.x - Grid.origin.x);
        let yDist = (point.y - Grid.origin.y);
        return Math.sqrt(xDist * xDist + yDist * yDist) / this.scale;
    }
    constructor (public scale: number) { }
}

let grid1 = new Grid(1.0);  // 1x scale
let grid2 = new Grid(5.0);  // 5x scale

console.log(grid1.calculateDistanceFromOrigin({x: 10, y: 10}));
console.log(grid2.calculateDistanceFromOrigin({x: 10, y: 10}));
```

## Others

### Use JavaScript

First we need to tell that exists some variable with the needed name
there:

    declare let BootstrapDialog: any;

    @Component({
    ...

Then we can use it on its code (to intercept callbacks:
`onComplete: () => { this.chartTestMethod(); }`

``` javascript
 BootstrapDialog.show({
              message: 'Hi Apple!',
              type: BootstrapDialog.TYPE_WARNING,
              buttons: [{
                  label: 'Button 2',
                  cssClass: 'btn-primary',
                  action: (dialogItself: any) => {
                    this.deleteMission(dialogItself);
                  }
              }, {
                  icon: 'glyphicon glyphicon-ban-circle',
                  label: 'Button 3',
                  cssClass: 'btn-warning'
              }, {
                  label: 'Close',
                  action: function(dialogItself: any){
                      dialogItself.close();
                  }
              }]
          });
```
