# React Blind Sticks

## Commands

-   `npx create-react-app my-app`
-   `npx create-react-app my-app --template redux`
-   `npx create-react-app my-app --template redux-typescript`

## Redux

``` javascript
import { createStore } from 'redux';
// Forbids to change the object structure
const initialState = Object.freeze({
    title: 'Beautiful Code',
    author: 'Douglas Crockford'
});

// State updater
function reducer(book = initialState, action) {
  switch (action.type) {
    case 'CHANGE_BOOK_TITLE':
      return {
        ...book,
        title: action.title
      }
    default:
      return book
  }
}
// Events listener that occour on the state
const store = createStore(reducer);
store.subscribe(function(){
  console.log(store.getState());
});
// Dispatch changes on the state
store.dispatch({ type: 'CHANGE_BOOK_TITLE', title: 'JavaScript The Best Parts' });
store.dispatch({ type: 'CHANGE_BOOK_TITLE', title: 'How JavaScript Works' });
```

## React basic

### Structure

    src
    ├── App.jsx
    ├── Footer.jsx
    ├── Header.jsx
    ├── index.js
    ├── TodoList.jsx
    ├── TodoSearch.jsx
    └── TodoView.jsx
    public
    ├── favicon.ico
    ├── index.html
    ├── logo192.png
    ├── logo512.png
    ├── manifest.json
    └── robots.txt

**index.html**

      <body>
        <div id="root"></div>
      </body>

Jsx files:

``` javascript
// index.js
import React from 'react';
import ReactDOM from 'react-dom';
import App from './App';

ReactDOM.render(<App />, document.getElementById('root'));

// App.jsx -----------------------------------------------------------------------------------------
import Header from './Header';
import TodoView from './TodoView';
import Footer from './Footer';
function App() {
  return (
    <div>
      <Header />
      <TodoView />
      <Footer />
    </div>
  );
}
export default App;

// Header.jsx -----------------------------------------------------------------------------------------
import React from 'react';

function Header(){
    return <header>Header</header>
}

export default Header;

// TodoView.jsx -----------------------------------------------------------------------------------------
import React from 'react';
import TodoSearch from './TodoSearch';
import TodoList from './TodoList';

function TodoView(){
    return (
        <div>
            <TodoSearch />
            <TodoList />
        </div>
    )
}

export default TodoView;
```
