# Python Typing

Devolver el tipo de la misma clase:

    from typing import Self

    class Foo:
       def returns_self(self) -> Self:
          return self

Alias de tipo:

    from typing import TypeAlias

    Factors: TypeAlias = list[int]

Definición de un tipo (en este caso self):

    from typing import TypeVar

    Self = TypeVar("Self", bound="Foo")

    class Foo:
       def returns_self(self: Self) -> Self:
          return self

Several types:

    Union[Union[int, str], float] == Union[int, str, float]
    Union[int] == int

Type or None: `Optional[X]` is equivalent to `X | None` (or
`Union[X, None]`).

    Optional[str]

Class type:

    class ShopifyPostView(MethodView):
        shopify_request_schema: t.Union[
            t.Type[ShopifyPaymentsRequest],
            t.Type[ShopifyRefundsRequest],
        ] = None

Object of the previous class type:

    ShopifyRequestClass: t.Type = t.Optional[
        t.Union[
            t.Type[ShopifyPaymentsRequest],
            t.Type[ShopifyRefundsRequest],
        ]
    ]

    ShopifyRequest = t.Type[ShopifyRequestClass]

# Links

-   <https://towardsdatascience.com/12-beginner-concepts-about-type-hints-to-improve-your-python-code-90f1ba0ac49>
