# Poetry

## Basic

### Create a project

    poetry new project

ℹ️ This will create a project folder in the current path.

### Initializing an existent project

    poetry init

### Install dependences

    poetry install

Or

    poetry install --no-root

### Add package

    poetry add package

#### From git repository

    poetry add git+repo_url

### Execute a command

    poetry run command

### List where the environment is

    poetry env list --full-path

### On a docker container

We do not need a virtual env docker. It is already isolated. So, we use

    poetry config virtualenvs.create false 

setting to turn it off.

### Install from existing requirements

    cat requirements.txt|xargs poetry add

## Use

### Versioning

For starting a new project we use:

    poetry new --src <path>

It generates this structure:

    .
    ├── pyproject.toml
    ├── README.rst
    ├── src
    │   └── project_name
    │       └── __init__.py
    └── tests
        ├── __init__.py
        └── test_project_name.py

In that project_name.py we find the version.

#### Check version

    poetry version

#### Set version

    poetry version 21.12.22

#### Bump version

    poetry version patch

You can set: `patch`, `minor`, `major`\... As it says in the next table:
![](/wiki2/python/poetry-version-table.png){.align-center width="400"}

#### Workflow

-   From
    <https://www.nicholasnadeau.com/post/2020/8/one-version-to-rule-them-all-keeping-your-python-package-version-number-in-sync-with-git-and-poetry/>

A typical release workflow with poetry looks something like this:

Use poetry to bump your package version: `poetry version patch`

    Bumping version from 0.1.0 to 0.1.1

Create a tag to define your release in git

    git tag 0.1.1
    git push --tags

Hope you used the same version number for both steps

To avoid human errors, we can link our poetry version to our git tags.

Update pyproject.toml to have a generic version placeholder

        [tool.poetry]
        version = "0.0.0"

Update your release script to fetch the git version before building the
package artifacts

    poetry version $(git describe --tags --abbrev=0)
    poetry build

#### Get version by code

    >>> import pkg_resources
    >>> my_version = pkg_resources.get_distribution('my-package-name').version

### Configure script

    [tool.poetry.scripts]
    dbcli = 'getfinancing.persistence.cli.dbcli:main'

## Other tips

### Show the dependences tree

    poetry show --tree

### Add latest package

    poetry add pymysql@latest

### Add from requirements.txt

    cat requirements.txt|xargs poetry add

### Add private repo

This creates the repo `gf` accessed with credentials.

    poetry config repositories.gf https://pip.getfinancing.us/simple/
    poetry config http-basic.gf $PYPI_USER $PYPI_PSW

### Use poetry with a concrete Python version

    poetry env use python3.9
