# OpenCV

## Install & use

### Install

    sudo apt-get install libopencv-dev python-opencv

### Use in Python

``` python
import numpy as np
import cv2

cap = cv2.VideoCapture(0)

while(True):
    # Capture frame-by-frame
    ret, frame = cap.read()

    # Our operations on the frame come here
    gray = cv2.cvtColor(frame, cv2.COLOR_BGR2GRAY)

    # Display the resulting frame
    cv2.imshow('frame',gray)
    if cv2.waitKey(1) & 0xFF == ord('q'):
        break

# When everything done, release the capture
cap.release()
cv2.destroyAllWindows()
```

### Use in C++

    g++ -ggdb `pkg-config --cflags opencv` -o `basename opencvtest.cpp .cpp` opencvtest.cpp `pkg-config --libs opencv`

``` cpp
#include <opencv2/highgui/highgui.hpp>
using namespace cv;

int main()
{
    Mat img = imread("/home/alfred/Desktop/screen.jpg",CV_LOAD_IMAGE_COLOR);
    imshow("opencvtest",img);
    waitKey(0);
    return 0;
 }
```

## Basic with images

### Create black image

``` python
import numpy as np
blank_image = np.zeros((height,width,3), np.uint8)
```

### Obtain ROI

``` python
>>> ball = img[280:340, 330:390]
>>> img[273:333, 100:160] = ball
```

### Write an image inside another

``` python
black_image[:height, :width] = frame[:,:]    
```

### Obtain the average color

``` python
color = np.mean(m_roi, axis=0)
```

### Draw figures

``` python
cv2.rectangle(black_image, (pos_x, pos_y), (pos_x + size_x, pos_y + size_y), (255, 255, 255))
```

## Video Capture

You can capture images and obtain the properties:

``` python
cap = cv2.VideoCapture(0)
width, height = cap.get(cv2.cv.CV_CAP_PROP_FRAME_WIDTH), cap.get(cv2.cv.CV_CAP_PROP_FRAME_HEIGHT)
```

VideoCapture properties in C++ are: CV_CAP_PROP_FRAME_WIDTH\...

## Others

### Get a sample of colors

``` python
idx_x = np.random.randint(colorset.shape[0], size=_size)
idx_y = np.random.randint(colorset.shape[1], size=_size)
sample = colorset[idx_y, idx_x, :]
```

### Change the shape of a num.array

Use `reshape`.
