# Linux Tools

## fsz

-   <https://github.com/junegunn/fzf>

Herramienta de autocompletado, para moverte con más agilidad en la
terminal.

Keybindings:

-   ctrl+r para buscar en el historial
-   ctrl+t para seleccionar ficheros. Por ejemplo: `rm` - ctrl+t -
    escoger ficheros con tab - enter

Luego también puedes:

    cd ** <TAB>
    ssh ** <TAB>

## KeyLogger

-   <https://github.com/kernc/logkeys>
-   ![LogKeys](/wiki2/linux/logkeys-master.zip)

```{=html}
<!-- -->
```
    $ logkeys --start -d /dev/input/event6 -m /home/alfred/Desktop/logkeys-master/keymaps/es_ES.map

    --no-daemon
    --no-func-keys
    --output file

## PDF merge

    sudo snap install pdftk
    pdftk file1.pdf file2.pdf cat output mergedfile.pdf

## Enable, disable, and check the Ubuntu firewall

    sudo ufw enable
    sudo ufw disable
    sudo ufw status

## Limit downloading

    sudo apt-get -y install wondershaper
    sudo wondershaper <interface name> <down speed> <up speed>
    sudo wondershaper eth0 512 512
    sudo wondershaper clear <interface name>

Wondershaper seems to work on x10, so to limit to 512Kbps and 50Kbps
would be:

    sudo apt-get install trickle
    sudo trickle -d 120 -u 32

## Screen

    screen ./unix-shell-script-to-be-executed parameters
    screen -ls
    screen -X -S [session # you want to kill] quit

## Rclone

<https://rclone.org/>

    cp rclone /usr/bin/
    chown root:root /usr/bin/rclone
    chmod 755 /usr/bin/rclone
    mkdir -p /usr/local/share/man/man1
    cp rclone.1 /usr/local/share/man/man1/
    mandb 

An example for filtering:
`rclone sync path0 path1 -vv --filter-from filter_file.txt`

    - .git/
    - .gitignore
    - tmp/**
    - .svn/
    - dist/*.tar
    - dist/*.zip
    - .idea/
    - __pycache__/
    - **.pyc
    + **/migrations/__init__.py
    - **/migrations/**
    + **/static/**
    - static/**
    + *

## entr - Run a command when a file changes

    $ ls | entr sass main.scss > ../main.css | echo "compile"

:!: I do not know why, but
`sass main.scss > ../main.css ; echo "compile"` does not work.

## MiniUPnP

Este paquete te permite llamar a los comandos UPnP de tu router y abrir
puertos desde la máquina local:

    upnpc -a <ip> <puerto> <puerto_router> <protocolo(TCP|UDP)>
    upnpc -a 192.168.1.130 8000 8000 UPD

## Snaps

List applications used by snap:

    snap list

Paths used by snap:

    ~/snap
    /snap
    /var/snap
    /var/lib/snapd

## Configure a DNS server

To install it add the `bind9` package. All its configuration for the
names is placed on the `/etc/bind` path.

You need to change the next file `/etc/default/bind9` to accept IP v4:

    # run resolvconf?
    RESOLVCONF=no
    # startup options for the server
    OPTIONS="-4 -u bind"

Add those IP\'s allowed to query DNS into the main config:

    allow-query { localhost;192.168.1.0/24; };

:!: Examples will configure test.test, wiki.test.test\...

After this, if we wanted to add an url name we should create a zone
(into the config for zones):

    zone "test.test" { 
         type master; 
         file "/etc/bind/db.test"; 
         allow-update { none; }; 
         allow-query {any; };
    }; 

And in the file `/etc/bind/db.test`:

    $TTL    86400
    @   IN  SOA dns.test. root.test.test. (
                     3      ; Serial
                 604800     ; Refresh
                  86400     ; Retry
                2419200     ; Expire
                 604800 )   ; Negative Cache TTL
    ;
    @ IN NS dns.test.
    wiki IN A 192.168.1.250
    auth IN A 192.168.1.251

After this we can restart the service bind9.

Before restarting it we can execute some checks:

-   `named-checkconf`
-   `named-checkzone test.test db.test`

More doc:

-   <https://help.ubuntu.com/community/BIND9ServerHowto>
-   ![](/wiki2/linux/how_to_configure_bind_as_a_private_network_dns_server_on_ubuntu_18.04_digitalocean.pdf){.align-center}
-   ![](/wiki2/linux/setting_up_bind_as_a_private_dns_server_on_rhel_8.pdf){.align-center}

## Pandoc

-   <https://pandoc.org>

Tool for converting between text documents formats.

Basic command:

    pandoc -s README.md -c custom.css -o README.html

-   <https://vimaltech.com/pandoc-markdown-to-html/>
-   ![Una serie de css sin
    clases](/wiki2/classless-styles.zip){.align-center}
-   [Sakura estilo](https://oxal.org/projects/sakura/)

![](/wiki2/screenshot_2021-02-09_pandoc_convert_markdown_to_html_using_a_custom_template.png){.align-left
width="100"}

### También para conversiones

Ver los input formats (también con output)

    pandoc --list-input-formats

Convertir:

    pandoc Desktop/javascript.txt -f dokuwiki -t markdown -o javascript.md

En el formato: `pandoc FILE -f INPUT_FORMAT -t TO_FORMAT -o OUTPUT_FILE`

## Tools list

-   [jq](https://stedolan.github.io/jq/), for making queries on json
    files.

### Watchexec

-   <https://crates.io/crates/watchexec>

For executing a command when a file from a dir changes.

    watchexec --exts py "printenv WATCHEXEC_META_CHANGED_PATH"
