# Linux Programming

Usar la salida del último comando (volviendolo a ejecutar):

    $ > echo pierre
    pierre
    $ > echo my name is $(!!)
    echo my name is $(echo pierre)
    my name is pierre

Exit status del último comando:

    $ touch /root/test
    touch: cannot touch '/root/test': Permission denied
    $ echo $?
    1

Añadir la salida de un comando como parámetro a otro

    $ ls $(echo ~)

Guardarlo en una variable

    alfred@alfred-Y50-70 ~/Desktop $ a=$(python crawler.py)
    alfred@alfred-Y50-70 ~/Desktop $ echo $a

Run with root:

    if [ "$(id -u)" != "0" ]; then
       echo "This script must be run as root" 1>&2
       exit 1
    fi

Si quieres que el script pare cuando haya un error interno añade la
siguiente línea al inicio de este:

    set -e

## Fast notes

#### Check if a directory or file exists

Looking the status code of:

    test -d /path

#### Wait to press a key

    read -n1 -r -p "Press any key to continue..." key;

#### Override a line in a config file

    sed -i 's/# auth-access = write/auth-access = write/' src/conf/svnserve.conf
    sed -i 's/# password-db = passwd/password-db = passwd/' doc/conf/svnserve.conf

#### Get formatted data

get year-month-day from date

    DATE=`date +%Y-%m-%d`

get year-month-day hour:minute:second from date

    DATE=`date '+%Y-%m-%d %H:%M:%S'`

    $ DATE=$(date +%y%m%d)
    $ echo $DATE
    190523

## Examples

Some Django shortcuts:

    resetmigrations() {
      if [ -z "$1" ]
        then
          echo "No database supplied"
          return
      fi
      echo "The $1 database is going to be reseted";
      read -n1 -r -p "Press any key to continue..." key;
      find . -path "*/migrations/*.py" -not -name "__init__.py" -delete
      find . -path "*/migrations/*.pyc"  -delete
      export PGPASSWORD=mysecretpassword;
      dropdb -h 127.0.0.1 -U postgres $1
      createdb -T template0 -h 127.0.0.1 -U postgres $1
      python manage.py makemigrations
      python manage.py migrate
    }
