# Gunicorn

## Basics

### Install

    $ sudo apt-get install gunicorn

Otra opción

    pip install gunicorn

### Execute

#### \... A web app in Flask

In cringier_app file

    gunicorn -w 4 -b 0.0.0.0:80 cringer_app:app

## In docker containers

Gunicorn's main process starts one or more worker processes, and
restarts them if they die. To ensure the workers are still alive,
Gunicorn has a heartbeat system. The default directory for the heartbeat
file is in /tmp, which in some Linux distributions is stored in memory
via tmpfs filesystem. Docker containers, however, do not have /tmp on
tmpfs.

One option is to mount a tmpfs or ramfs in-memory filesystem onto /tmp,
using Docker's volume support. This will work, but not everywhere: not
all environments that run Docker containers support arbitrary volumes.

A more general solution is to tell Gunicorn to store its temporary file
elsewhere.

    gunicorn --worker-tmp-dir /dev/shm

If you only have one worker, and it's stuck handling a slow query, the
heartbeat query will timeout. Start at least two workers, and probably
also start a number of threads using the gthread worker backend.

    gunicorn --workers=2 --threads=4 --worker-class=gthread

Speaking of nginx, you don't always nedd nginx or another proxy in front
Gunicorn. Many container deployment systems already have a HTTP load
balancer/reverse proxy built-in, in which case Gunicorn isn't being
exposed directly to HTTP clients anyway.

### An example of gunicorn app in Docker

    gunicorn rema.wsgi:application --bind 0.0.0.0:8000 --worker-tmp-dir ~ --workers=2 --threads=4 --worker-class=gthread
