# Graphics

## Bezier curves

-   ![](/wiki2/graphics/decasteljau_algorithm.pdf)

## Snippets

### Draw sinus

In openframeworks:

``` cpp
path.clear();

auto dx = (TWO_PI / 500.0) * 16;
float x = ofGetElapsedTimef();
auto space = 50.0, amplitud = 78.0;

auto y = sin(x) * amplitud;
x+=dx;
path.moveTo(0, ofGetHeight() / 2 + y);

for (int i = 1; i < 25; i++) {
    y = sin(x) * amplitud;
    x+=dx;
    path.curveTo(i * space, ofGetHeight() / 2 + y);
}
```

### Draw circle

``` cpp
auto angle = .0;
auto x = 0, y = 0;
auto radio = 300;
while (angle < 360) {
        // calculate x, y from a vector with known length and angle
        x = radio * cos (angle * DEG_TO_RAD);
        y = radio * sin (angle * DEG_TO_RAD);
        ofCircle(x + ofGetWidth() / 2, y + ofGetHeight() / 2, 3);
        angle += 10;
}
```

### Rotate figure when its center is 0,0

``` cpp
vector<ofPoint> points = {
    ofPoint(x-50, y-50),
    ofPoint(x+50, y-50),
    ofPoint(x+50, y+50),
    ofPoint(x-50, y+50),
    ofPoint(x-50, y-50)
};
ofSetLineWidth(3);
ofNoFill();
ofBeginShape();
for (auto& vertex : points) {
    x = vertex.x*cos(angle * DEG_TO_RAD) - vertex.y*sin(angle * DEG_TO_RAD);
    y = vertex.y*cos(angle * DEG_TO_RAD) + vertex.x*sin(angle * DEG_TO_RAD);
    x += 250;
    y += 250;
    ofVertex(x, y);
}
ofEndShape();
```
