# Git tools

## Gitlist

-   <http://gitlist.org/>
-   <https://github.com/klaussilveira/gitlist>
-   <https://github.com/klaussilveira/gitlist/wiki/Troubleshooting>
-   <https://github.com/klaussilveira/gitlist/blob/master/INSTALL.md>
-   <https://github.com/klaussilveira/gitlist/issues/322>

## Gitea

Supervisor config file for the process:

    [program:gitea]
    user = root
    directory=/srv/gitea/
    command=/srv/gitea/gitea web
    autostart=true
    autorestart=false
    environment = HOME="/home/root", USER="root"

## Git Extras

### git info

    $ git info

    ## Remote URLs:

    origin      git@github.com:sampleAuthor/git-extras.git (fetch)
    origin      git@github.com:sampleAuthor/git-extras.git (push)

    ## Remote Branches:

    origin/HEAD -> origin/master
    origin/myBranch

    ## Local Branches:

    myBranch
    * master

    ## Most Recent Commit:

    commit e3952df2c172c6f3eb533d8d0b1a6c77250769a7
    Author: Sample Author <sampleAuthor@gmail.com>

    Added git-info command.

    Type ´git log´ for more commits, or ´git show <commit id>´ for full commit details.

    ## Configuration (.git/config):

    color.diff=auto
    color.status=auto
    color.branch=auto
    user.name=Sample Author
    user.email=sampleAuthor@gmail.com
    core.repositoryformatversion=0
    core.filemode=true
    core.bare=false
    core.logallrefupdates=true
    core.ignorecase=true
    remote.origin.fetch=+refs/heads/*:refs/remotes/origin/*
    remote.origin.url=git@github.com:mub/git-extras.git
    branch.master.remote=origin
    branch.master.merge=refs/heads/master

### pull requests & merge requests

-   git-mr checks out a merge request from GitLab
-   git-pr checks out a pull request on GitHub

```{=html}
<!-- -->
```
    $ git mr 51
    From gitlab.com:owner/repository
     * [new ref]         refs/merge-requests/51/head -> mr/51
    Switched to branch 'mr/51'

### git-release

By combining commit, tag, and push into a single command, git-release
saves a lot of keystrokes for executing three commands that often run in
sequence.

To commit with a specific \<tagname\> and a custom message:

    $ git release 0.1.0 -m <+ powerful feature added>

### Patches

Create a file with changes:

-   Create a git patch for each changed file:
    `git format-patch <target-branch>`
-   Create only one git patch file with all changes:
    `git format-patch <target-branch> --stdout patch_name.patch`
-   Create a path from a commit: `git format-patch -1 <commit-hash>`
-   Show the path changes: `git apply --stat <patch_file_path>`
-   Apply the path: `git apply <patch_file_path>`
-   Apply the path and create a commit: `git am <patch_file_path>`

## pre-commit

-   <https://pre-commit.com/>
-   <https://ljvmiranda921.github.io/notebook/2018/06/21/precommits-using-black-and-flake8/>
-   <https://black.readthedocs.io/en/stable/version_control_integration.html>
-   <https://github.com/pre-commit/pre-commit-hooks#no-commit-to-branch>

Install:

    sudo pip3 install pre-commit

To use it with black, add this to .pre-commit-config.yaml:

    repos:
      - repo: https://github.com/psf/black
        rev: stable
        hooks:
          - id: black
            language_version: python3.8

Then to set up the git hook scripts

    run pre-commit install 

Now pre-commit will run automatically on git commit!

    pre-commit run --all-files

## Git Hooks

-   <https://githooks.com/>
-   <https://github.com/aitemr/awesome-git-hooks>
-   <https://itnext.io/using-git-hooks-to-enforce-branch-naming-policy-ffd81fa01e5e>
-   <https://www.devwithimagination.com/2020/04/13/git-commit-hooks-for-branch-naming-pre-commit/>
