# GIT commands

## Repositories

### Creating them

#### Without a tree code

`bare` parameter allows that:

    ssh git@example.com
    mkdir my_project.git
    cd my_project.git
    git init --bare
    git update-server-info # If planning to serve via HTTP
    exit

### Use a remote repository

    cd my_project
    git init
    git add *
    git commit -m "My initial commit message”
    git remote add origin git@example.com:my_project.git
    git push -u origin master

#### Add a new ssh origin

    git remote add origin ssh://estudiobay/repos/wallstreetjournal/demo.unity.git
    git remote add origin ssh://wikis/var/www/repos/shellscripts/

#### Add another remote (and push)

    git remote add newskid ssh://newskid/home/ubuntu/repos/backend.git
    git push newskid

### Clonning

#### By ssh

    git clone ssh://estudiobay/repos/fcbarcelona/gamepass.android.git/

### Listing information

-   List remotes: `git remote -v`

## Information

-   To know what\'s the status of the repository: `git status`
-   To know previous commits: `git log`
-   To show remote repositories: `git remote -v`
-   To view a file in a concrete commit:
    `git show REVISION:path/to/file`

### View the graph

    git log --graph --oneline --abbrev-commit

## Files and folders

### Remove

Remove file without removing from directory:

    git rm --cached mylogfile.log

For a directory:

    git rm --cached -r mydirectory

## Commit

### Reset

    $ git reset --hard HEAD~
    $ git push -f

### Automatically add all untracked files

    $ git commit -A

### Remove a file from the commit

    $ git reset HEAD path/to/unwanted_file

### Undo last commit

     git reset HEAD~ 

### Unstage changes

    git rm --cached -r -- .

## Reset

### Reset a full repo

    git reset --hard HEAD
    git clean -f -d

### Reset a single file

    git checkout filename

### Reset a file with the same name as a branch

    git checkout -- filename

### Remove not tracket files

    git clean -f -d 

## Branches

-   Create new branch: `git checkout -b [name_of_your_new_branch]`
-   To change branch: `git checkout [name]`
-   Push new branch to github:
    `git push origin [name_of_your_new_branch]`
-   See all branches: `git branch`
-   To delete a local branch: `git branch -d the_local_branch`
-   To remove a remote branch: `git push origin :the_remote_branch`

### Guardar en una branch los cambios realizados

    git checkout -b my_new_branch
    git commit

### Eliminar branch

#### Local

    git branch -D no_queues

#### Remota

    git push origin --delete test

### Checkout de branch remota en local

    git checkout -b <local_name> <remote_name>
    git checkout -b no_queues remotes/origin/#001_no_queues

## Stash

-   To save a state of the work: `git stash`
-   To list saved states: `git stash list`
-   To return to a stash state: `git pop stash@{1}`
-   To clean saved states: `git stash clear`

## Moving in the repo

-   Move to a previous commit: `git checkout 45a33` (it\'s not needed to
    put all the identifier)
-   Return to the master: `git checkout master`
-   To know \"open fronts\": `git branch`

## Tags

List tags: `git tag -l`

Create a tag in the current commit: `git tag -a 2.4.5`

Upload tags to the remote: \'\'git push origin \--tags \'\'

Remove a tag:

    git push --delete origin <tagname>

## Push over a non-bare repo

You need to set denyCurrentBranch

    $ git init
    $ git config receive.denyCurrentBranch ignore
    <then you can push>
    $ git checkout <desired_branch>

If you want to return to the default behavior:

    $ git config receive.denyCurrentBranch refuse

And to update:

    git reset --hard

## Submodules

Create a submodule linked directly to the theme's GitHub repository in
order to receive updates:

    $ git submodule add https://github.com/tomanistor/osprey.git themes/osprey
    $ git submodule update --init --recursive --remote

To update a downloaded repo with submodules:

    $ git submodule init
    $ git submodule update

## Merges

You should always keep in mind that you can return to the state before
you started the merge at any time. This should give you the confidence
that you can\'t break anything. On the command line, a simple
`git merge --abort` will do this for you.

In case you\'ve made a mistake while resolving a conflict and realize
this only after completing the merge, you can still easily undo it: just
roll back to the commit before the merge happened with \'\'git reset
\--hard \'\' and start over again.

## Bundle

Create a bundle file:

    git bundle create your_name.bundle --all

Use it:

    git clone <path_to_bundle_file>

## Fixing

### A detached head

<https://stackoverflow.com/a/14757539>

If you type `git reflog`, it will show you the history of what revisions
`HEAD` pointed to. Your detached head should be in there. Once you find
it, do `git checkout -b my-new-branch abc123`or
`git branch my-new-branch abc123` (where `abc123` is the SHA-1 of the
detached HEAD) to create a new branch that points to your detached head.
Now you can merge that branch at your leisure.

Generally, if you check out a branch after working on a detached head,
Git should tell you the commit from the detached head you had been on,
so you can recover it if you need. I\'ve never used SourceTree, so I
don\'t know if it relays that message. But if it did display that
message, then you should be able to use that to find the commit, and
again use `git checkout -b` or `git branch` to create a branch from that
commit.

## Extra

### Defining message editor

    git config --global core.editor "nano -w"

### Use meld for UI for merging

To use it for the current repo:

    $ git mergetool -t meld

To configure git to remember which merge tool you want, type git config
--global merge.tool \[tool\]. For meld use:

    $ git config --global merge.tool meld

### Several remotes

You can have as many remotes as you want, but you can only have one
remote named \"origin\". The remote called \"origin\" is not special in
any way, except that it is the default remote created by Git when you
clone an existing repository. You can configure a second remote, push
to/pull from that remote, and setup some branches to track branches from
that remote instead of origin.

Try adding a remote called \"github\" instead:

    $ git remote add github https://github.com/Company_Name/repository_name.git
    # push master to github
    $ git push github master
    # Push my-branch to github and set it to track github/my-branch
    $ git push -u github my-branch
    # Make some existing branch track github instead of origin
    $ git branch --set-upstream other-branch github/other-branch

Other easier:

    git remote add gitea https://git.alfredgg.dev/gtd/docker-without-pants.git
    git push gitea

### Use git from another folder

    $ git -C /home/alfred/Documents/workspaces/python/newskid.frontend push

### Avoid git asking for password

For one day (86400), one hour (3600)\...

    git config --global credential.helper 'cache --timeout 86400'

    git config credential.helper store

### Gitlab beginning

Git global setup

    git config --global user.name "user1"
    git config --global user.email "user1@test.com"

Create a new repository

    git clone http://127.0.0.1/user1/test.git
    cd test
    touch README.md
    git add README.md
    git commit -m "add README"
    git push -u origin master

Existing folder

    cd existing_folder
    git init
    git remote add origin http://127.0.0.1/user1/test.git
    git add .
    git commit -m "Initial commit"
    git push -u origin master

Existing Git repository

    cd existing_repo
    git remote rename origin old-origin
    git remote add origin http://127.0.0.1/user1/test.git
    git push -u origin --all
    git push -u origin --tags
