# Basic Elm

### Basic actions

    "hello" ++ " world"  -- Concatenate strings
    'a' -- Is a character
    "a" -- Is a string
    1 /= 2  -- True, 1 != 2 
    c = 1 == 1 -- True
    [1, 2, 3] ++ [4, 5, 6] -- Concatenar listas
    List.range 1 100 -- Creates a list from 1 to 100
    4 :: [1, 2, 3]  -- [4, 1, 2, 3]
    String.isEmpty "am I empty"  -- False
    String.join ", " (List.sort ["Bob" , "Zack", "Mike"])

    answer = 45
    if answer < 42 then "Under 42" else "42 or more"

In Elm we do not have to worry about declaring variables, data is
immutable and it infires the type.

Functions:

    squarer number  = number * number -- <function> : number -> number
    squarer 10  -- 100

    stringAdd s1 s2 = s1 ++ " " ++ s2
    stringAdder = stringAdd "Hey"
    strinngAdder "there!"  -- "Hey there"

    numAdder n1 n2 = n1 + n2
    numAdder2 n1 n2 = n1 + n2
    numAdder 10 (numAdder2 5 5)  -- 20

    10 \
      |> squarer  -- 10, multiline pass arguments
      
    ["Adam", "Molly", "Zeke", "Jane"] \
    |> List.sort \
    |> String.join ", " -- Adam, Jane, Molly, Zeke

    checkTheAnser = anser = |
      if answer > 42 then \
        "Greater than 42" \
      else if answer == 42 then \
        "Answer is 42" \
      else \
        "Under 42" -- <function> number -> String

    (True, 42, "Bob")
    [(Bool, 100), (True, 200)] -- These tuples have to have the same types inside

Records

    bob = { name = "Bob", age = 30 }
    bob.name -- Bob
    .age bob -- 30 , is like calling a function into bob
    bob2 = { bob | age = 31 } -- { name = "Bob", age = 31 }

    user1 = {id = 1, name ="bob" }
    user2 = {name = "jane" } -- We forgot id

    type alias User = {id : Int, name : String }
    user1 = User 1 "bob"
    user2 = User 2 "jane"

    userChecker { id } = \
      if id > 1 then \
        "Greater than 1"
      else \
        "Is the first one"
    userChecker user2  -- Greater than 1

Modules (file Hello.elm):

    module Hello exposing (..)  -- exposes everything inside the module

    import Html exposing (text)  -- we take text from Html

    main = 
      text "Hello world"

Creating html

    module HelloHtml exposing (..)

    import Html exposing (text, div, h1)  -- we take text, div, h1 from Html
    import Html.Attributes expossing (class)

    main : Html msg                               -- specifies the type (avoid warnings)
    main = 
      div [ class "main-div" ] [                  -- class div with attributes and childs 
        h1 [ class "title"] [text "Welcome"]
        , p[] [text "I'm liking this"]
        , p[] [text "lets try"]
      ]

To install packages:

    elm install elm-lang/html

To compile a module (we can send \--warn):

    elm build src/Main.elm

#### Explicación

-   <https://guide.elm-lang.org/core_language.html>

To declare a function (type anotation) that gets a number and returns an
string:

    checkStatus : Int -> String

If you write \"checkStatus\" it will return
`<function> : Int -> String`.

It is something like this:

    <function: add> : Int      -> Int      -> Int
    | function name | type arg1 | type arg2 | type result |

Now lets define it:

    checkStatus status =
        if status == 200 then
            "You got it, dude!"
        else if status == 404 then
            "Page not found"
        else
            "Unknown response"

### Examples


    import Html exposing (..)


    checkStatus : Int -> String
    checkStatus status =
        if status == 200 then
            "You got it, dude!"
        else if status == 404 then
            "Page not found"
        else
            "Unknown response"


    statusChecks : List String
    statusChecks =
        [ checkStatus 200
        , checkStatus 404
        , checkStatus 418
        ]


    renderList : List String -> Html msg
    renderList lst =
        lst
            |> List.map createLi
            |> ul []


    createLi : String -> Html msg
    createLi str =
        li [] [ text str ]


    main =
        div []
            [ h1 [] [ text "List of statuses:" ]
            , renderList statusChecks
            ]
