# OpenFrameworks

## Installation and use

### Installation

### Use in Eclipse

-   Follow the tutorial until have OpenFrameworks and Addons in your
    projects.

Import the generated project as \"Existing code as makefile project\".
You only need to add OpenFrameworks and Addons projects as references in
your new project (do not forget to select \"Linux GCC\").

### Notes

-   **To add an addon after having created the project** you just need
    to include its name in the `addons.make` file.
-   To compile with **C++11** you need to go to
    `libs/openFrameworksCompiled/project/makefileCommon` path and edit
    the main makefile which is `compile.project.mk`. You need to search
    for the rule that does the compilation and add: `-std=c++0x`.

``` cpp
$(OF_PROJECT_OBJ_OUPUT_PATH)%.o: $(PROJECT_ROOT)/%.cpp
    @echo "Compiling" $<
    @mkdir -p $(@D)
    $(CXX) -c $(OPTIMIZATION_CFLAGS) $(CFLAGS) $(CXXFLAGS) -std=c++0x -MMD -MP -MF $(OF_PROJECT_OBJ_OUPUT_PATH)$*.d -MT $(OF_PROJECT_OBJ_OUPUT_PATH)$*.o -o $@ -c $<
```

-   Muy probablemente quieras usar otras libs, las tendrías que añadir
    también en el makefile:

``` cpp
$(TARGET): $(OF_PROJECT_OBJS) $(OF_PROJECT_ADDONS_OBJS) $(OF_PROJECT_LIBS) $(TARGET_LIBS)
    @echo 'Linking $(TARGET) for $(ABI_LIB_SUBPATH)'
    @mkdir -p $(@D)
    $(CXX) -o $@ $(OF_PROJECT_OBJS) $(OF_PROJECT_ADDONS_OBJS) $(TARGET_LIBS) $(OF_PROJECT_LIBS) $(LDFLAGS) $(OF_CORE_LIBS)  -lboost_system -lboost_timer -lboost_thread 
```

## Useful data

### Obtain information

-   Ventana
    -   ofGetWidth(), ofGetHeight()
-   Programa
    -   ofGetElapsedTimef(), ofGetElapsedTimeMicros(),
        ofGetElapsedTimeMillis()

### Useful constants

-   TWO_PI
-   DEG_TO_RAD (any number we multiply by DEG_TO_RAD will be converted
    to radians)

## Graphics

-   [Creating
    Graphics](/wiki2/cpp/libraries/openframeworks/creating_graphics)

## Addons

### ofxNetwork

#### UDP

Crear un listener de UDP:

``` cpp
#include "ofxNetwork.h"

ofxUDPManager udpConnection;

udpConnection.Create();
udpConnection.Bind(5001);
udpConnection.SetNonBlocking(true);

char udpMessage[10000];
udpConnection.Receive(udpMessage,10000);
std::string message=udpMessage;
```

### ofxJSON

-   <https://github.com/jefftimesten/ofxJSON>

``` cpp
#include "ofxJSON.h"
...
ofxJSONElement result;
std::string url = "http://127.0.0.1:5000/sketch/1";
bool parsingSuccessful = result.open(url);

if (parsingSuccessful)
{
    //ofLogNotice("ofApp::setup") << "Ok!" << endl << result.getRawString() << endl;
    Json::Int64 value = result["paths"][0]["start_t"].asInt64();
    ofLogNotice("ofApp::setup") << value << endl;
    Json::ArrayIndex npoints = result["paths"][0]["points"].size();
    ofLogNotice("ofApp::setup") << npoints << endl;

    for (unsinged int i=0; i<result["paths"][0]["points"].size(); i++)
        ofxJSONElement point = result["paths"][0]["points"][i];

    ofxJSONElement result2;
    ofLogNotice("ofApp::setup") << result2.parse("{\"hola\": \"adios\"}");
    ofLogNotice("ofApp::setup") << result2["hola"].asString();
}
else
{
    ofLogNotice("ofApp::setup")  << "Failed to parse JSON" << endl;
}
```

### Addons Repository

-   <http://www.ofxaddons.com/categories>

## Snippets

-   [OpenFrameworks
    Snippets](/wiki2/cpp/libraries/openframeworks/snippets)
