# Chipmunk

## Bodiess and shapes

### Bodies

A Chipmunk body represents an object in the Chipmunk virtual space. It
can contain one or more Chipmunk shapes that represent the object's
geometry. There are two kinds of Chipmunk bodies:

-   Dynamic bodies are bodies that can move -- you'll be using these
    most of the time.
-   Static bodies are bodies that never move -- these are good to use
    for the ground in your game and other permanent fixtures.

For each Chipmunk body, you can specify how much mass it has. The more
mass a shape has, the harder it is to move around and the heavier it
becomes.

### Shapes

When you create shapes, you can specify whether they are boxes, circles,
polygons, or segments (which are straight lines with a thickness). On
each shape, you can set several properties, including the following:

      * elasticity: Represents how bouncy an object is. If you set this to 0, it’s not bouncy at all. If you set it to 1, it bounces back up with the same exact force it bounced down. If you set it higher to 1, it bounces away with an even higher force!
      * friction: Represents how slippery an object is. If you set this to 0, it’s extremely slippery. If you set this to 1 or higher, it’s not very slippery at all.

To define which areas of a body interact with the rest of the world and
those different surfaces, you need to add one or more Shapes to a body.
There are 3 types of shapes available with Chipmunk: circle, segment and
poly. Combining those 3 shape types you can define almost any area of
interaction imaginable for your bodies. Obviously, shapes added to the
same body don\'t produce collisions between themselves.

### Code

#### C++

``` cpp
// Create our ball's body with 100 mass  and infinite moment  
cpBody *ballBody = cpBodyNew(100.0, INFINITY);  
// Set the initial position  
ballBody->p = cpv(160, 250);  
// Add the body to the space  
cpSpaceAddBody(space, ballBody);  
```

#### Python

## Movement

The main method of changing things on Chipmunk, just like in the real
world, is to use and apply Forces. A force is a vector , you tell the
strength along the XX and YY axis. To help working with vectors,
Chipmunk comes with a library called cpVect that allows you to do the
most common operations like multiplying vectors or projecting two
vectors.
