# Angular Specifics

## Templates

Podemos ampliar el HTML de nuestra página:

    <h3>
      {{title}}
      <img src="{{heroImageUrl}}" style="height:30px">
    </h3>

También evaluar expresiones:

    <p>The sum of 1 + 1 is {{1 + 1}}</p>
    <p>The sum of 1 + 1 is not {{1 + 1 + getVal()}}</p>

En esta evaluación de expresiones podemos usar el new de JS, encadenar
expresiones con `;` pero no podemos acceder al `window`, `document`,
`console.log` o `Math.max` (sólo permite los miembros del contexto).

Cuando vemos algo tipo `{{title}}` nos referimos a la propiedad `title`
del componente. Cuando vemos algo así `[disabled]="isUnchanged"` nos
referimos a la propiedad `isUnchanged` del componente que se asigna a la
propiedad `disabled` de la tag.

Para enlazar los eventos usamos la siguiente sintaxis:
`(event)="statement"`

    <button (click)="onSave()">Save</button>

Para enlazar una propiedad en two-way (es decir que cuando se cambie que
también cambie el objeto Angular cuando cambie el valor en el HTML):
`[(target)] = "expression"`

Cambiar propiedades:

    <img [src] = "heroImageUrl">
    <hero-detail [hero]="currentHero"></hero-detail>
    <div [ngClass] = "{selected: isSelected}"></div>

Cambiar eventos:

    <button (click) = "onSave()">Save</button>
    <hero-detail (deleteRequest)="deleteHero()"></hero-detail>
    <div (myClick)="clicked=$event">click me</div>

Cambiar evento y propiedad:

    <input [(ngModel)]="heroName">

Cambiar un atributo:

    <button [attr.aria-label]="help">help</button>

Cambiar la clase:

    <div [class.special]="isSpecial">Special</div>

Cambiar el estilo:

    <button [style.color] = "isSpecial ? 'red' : 'green'">

Para editar el target más común usamos `ngClass`:

    <div [ngClass]="classes">[ngClass] binding to the classes property</div>

*Technically, Angular is matching the name to a directive input, one of
the property names listed in the directive's inputs array or a property
decorated with \@Input(). Such inputs map to the directive's own
properties.*

La propiedad `hero` de `HeroDetail` espera un objeto del tipo `Hero`
(los brackets indican a Angular que evalue la expresión, sino sería
tomado como un string):

    <hero-detail [hero]="currentHero"></hero-detail>

Los siguientes pares hacen la misma acción:

    <p><img src="{{heroImageUrl}}"> is the <i>interpolated</i> image.</p>
    <p><img [src]="heroImageUrl"> is the <i>property bound</i> image.</p>

    <p><span>"{{title}}" is the <i>interpolated</i> title.</span></p>
    <p>"<span [innerHTML]="title"></span>" is the <i>property bound</i> title.</p>

When developing data entry forms, we often want to both display a data
property and update that property when the user makes changes.

Cuando tratamos con datos introducidos por el usuario querremos que lo
que se muestra y lo que se almacena coincida, esto lo permite el
`[(ngModel)]`:

    <input [(ngModel)]="currentHero.firstName">

### Clausulas

Hay clausulas ( :!: precedidas por `*`) que permiten el render de la
vista en bucle o condicional:

    <li *ngFor="let hero of heroes">
      <span class="badge">{{hero.id}}</span> {{hero.name}}
    </li>

El \* para `ngFor` indica que el elemento \<li\> (y sus hijos) son una
template. `ngFor` itera sobre los heroes devueltos por
AppComponent.heroers y los añade a la template. El código entre comillas
indica \"coger cada hero en el array de heores, guardarlo en la variable
hero y permitir su acceso desde ese elemento\". El keyword led indica
que hero es una variable de entrada.

#### ngFor

    <div *ngFor="let hero of heroes">{{hero.fullName}}</div>

    <div *ngFor="let hero of heroes; let i=index">{{i + 1}} - {{hero.fullName}}</div>

#### ngForTrackBy

#### ngIf

#### ngSwitch
