# Angular concrete

## Components

### Lifecycle hooks

``` javascript
import { OnInit } from '@angular/core';

export class AppComponent implements OnInit {
  ngOnInit() {
  }
}
```

### Call method of a nested component

``` html
<nk-activities #nkActivities></nk-activities>
<a style="cursor:pointer;" (click)="nkActivities.createActivity(0, 'Talk')">Dialogue</a>
```

## Templates

### Access to HTML tags

``` html
<input #newHeroName />
<button (click)="addHero(newHeroName.value); newHeroName.value=''">
```

### Access to a form

``` html
    <form (ngSubmit)="onSubmit()" #missionForm="ngForm">
        <input type="text"  class="form-control" required [ngModel]="mission.name" name="name">
        <button type="button" class="btn btn-default" (click)="updateMission(missionForm.form.controls)"><span class="glyphicon glyphicon-open" aria-hidden="true"></span> Update Name</button>
        
```

### ngFor with index

``` html
<ul>
  <li *ngFor="let item of items; let i = index">
    {{i}} {{item}}
  </li>
</ul>
```

### Combining ngFor and ngIf

      <select class="form-control" [(ngModel)]="value" (change)="valueChanged.emit($event.target.value)" name="content">
      <template ngFor let-f [ngForOf]="files">
        <option [value]="f.id">{{f.name}}</option>
      </template>
      </select>

## Others

### String values

``` javascript
let url = `${this.heroesUrl}/${hero.id}`;
```
