# JSON

El nombre viene de JavaScript Object Notation, es un formato de texto
fácil de leer por JavaScript. Es un reemplazo perfecto al XML como
formato de intercambio de datos.

## Sintaxis

    object
        {}
        { members } 

    members
        pair
        pair , members

    pair
        string : value

    array
        []
        [ elements ]

    elements
        value
        value , elements

    value
        string
        number
        object
        array
        true
        false
        null

    string
        ""
        " chars "
    chars
        char
        char chars

    char
        any-Unicode-character-
            except-"-or-\-or-
            control-character
        \"
        \\
        \/
        \b
        \f
        \n
        \r
        \t
        \u four-hex-digits 

    number
        int
        int frac
        int exp
        int frac exp 

    int
        digit
        digit1-9 digits
        - digit
        - digit1-9 digits 

    frac
        . digits

    exp
        e digits

    digits
        digit
        digit digits

    e
        e
        e+
        e-
        E
        E+
        E-

### Comparación JSON con XML

El siguiente código en JSON\...

     {"menu": {
       "id": "file",
       "value": "File",
       "popup": {
         "menuitem": [
           {"value": "New", "onclick": "CreateNewDoc()"},
           {"value": "Open", "onclick": "OpenDoc()"},
           {"value": "Close", "onclick": "CloseDoc()"}
         ]
       }
     }}

\... equivale al siguiente en xml\...

``` xml
<menu id="file" value="File">
  <popup>
    <menuitem value="New" onclick="CreateNewDoc()" />
    <menuitem value="Open" onclick="OpenDoc()" />
    <menuitem value="Close" onclick="CloseDoc()" />
  </popup>
</menu>
```

## Combinandolo con JavaScript

Para parsear objetos JSON lo mejor es utilizar el parseador oficial del
creador, en [JSON2](http://www.json.org/json2.js) y en
![JSON2](/tags/json/json2_parser.rar).\
Lo agregaremos de la siguiente forma:

``` html
<script type="text/javascript" src="json2.js"></script>
```

### Convertir un objeto a texto JSON

Con este parseador nos es muy sencillo convertir un objeto JavaScript a
texto JSON:

``` javascript
 var obj = {
   name : 'Jeffrey',
   lastName : 'Way'
}
var json_txt = JSON.stringify(obj);
```

### Convertir un texto JSON a objeto

Simplemente debemos pasar el texto JSON al método `JSON.parse`.

``` javascript
var myobj = JSON.parse(json_txt);
alert(myobj.name);
```

### Convertir un texto JSON a objeto con eval

Otra opción para convertir un texto en formato JSON a un objeto
JavaScript es utilizar la función `eval`, esta forma es inmediata del
lenguaje, es decir sin necesidad de utilizar el parser, pero utilizar
esta función está desaconsejado debido a lo insegura que es:

``` javascript
var myobj = eval('(' + json_txt + ')');
```

## Formatos derivados

### JSONP

Viene del nombre *JSON with Padding*, es una forma de complementar el
formato JSON que permite llamar directamente a una función JavaScript
mediante una cadena en formato JSON.\
La idea es que el mismo servidor devuelva código JavaScript que llame a
una función. Por ejemplo, sabiendo que
`http://server2.example.com/getjson` devuelve:

    {"Name": "Cheeso", "Rank": 7}

Podríamos decir que para que tubiese la \"propiedad\" de JSONP
tendríamos que pasar el parámetro `jsonp` con el nombre de la función a
la que se llamará de la siguiente forma:

``` html
<script type="text/javascript" src="http://server2.example.com/getjson?jsonp=parseResponse"></script>
```

Y esto retornaría:

    parseResponse({"Name": "Cheeso", "Rank": 7})
