# (X)HTML & CSS Xtra

## CSS Como\...

### Centrar una div horizontalmente

``` css
.wrap { margin:0 auto 0 auto; width:390px; }
```

### Centrar una div verticalmente

``` css
body
{
    height:100%;
} 

.main_wrapper
{
    position: absolute;
    top: 15%;
    height: 70%;
    width: 100%;
}
```

### Div con 100% de alto

``` css
body 
{
    margin:0;
    padding:0;
    height:100%;
}

.leftColumn 
{
    position:absolute;
    left:0;
    top:0;
    padding:0;
    width:200px;
    height:99%;
    color:#333;
    background:#eaeaea;
    border:1px solid #333;
}
```

Si lo hacemos en el body y lo hacemos al 100% nos aparecerán unas barras
de desplazamiento. Podríamos indicar el alto de 99.9% o poner en el
estilo de la tag `body` un `overflow hidden`.

### Permitir que un objeto flash esté por debajo de una div

Agrega el parámetro `<param name="wmode" value="transparent" />` y en el
tag `embed` la propiedad `wmode="transparent"`:

``` xml
<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"
        id="FlexApplication1"
        codebase="http://fpdownload.macromedia.com/get/flashplayer/current/swflash.cab">
        <param name="wmode" value="transparent" />
        <param name="movie" value="FlexApplication1.swf" />
        <param name="quality" value="high" />
        <param name="allowScriptAccess" value="sameDomain" />
        <embed src="FlexApplication1.swf" quality="high" 
          width="100%" height="100%" 
          name="FlexApplication1" 
          align="middle"
            play="true"
            loop="false"
            quality="high"
            allowScriptAccess="sameDomain"
            type="application/x-shockwave-flash"
            pluginspage="http://www.adobe.com/go/getflashplayer"
            wmode="transparent">
        </embed>
</object>
```

### DIV en el final de la página

``` css
div.footer
{
    clear: both;
    height: 30px;
    border-top: 1px solid green;
    position:absolute;
    bottom:0;
    left:0;
    width:100%;
}
```

### Centrar tabla en una div

``` css
div.menu
{    
    width: 100%;
    text-align: center;
}

div.menu table
{
    margin-left:auto;
    margin-right:auto;
    text-align:left;
}
```

### Tablas\...

#### Cellspacing

``` css
table 
{
    border-collapse: collapse;
    border-spacing: 0px;
}
```

## CSS3

### Background

La propiedad background puede ahora definirse por partes:

``` css
background-image: url(top-left.gif), url(top-right.gif), url(bottom-left.gif), url(bottom-right.gif);
background-repeat: no-repeat, no-repeat, no-repeat, no-repeat;
background-position: top left, top right, bottom left, bottom right;
```

### Border

-   Podemos indicar los grados en los que el borde se redondea mediante
    la propiedad: `border-radius`.

``` css
.box {
    background-image: none;
    border-radius: 1.6em;
}
```

### Opacity

-   Podemos indicar el porcentaje de opacidad del fondo mediante la
    nueva propiedad: `opacity`.

``` css
.box {
    background-image: url(imagen.gif);
    opacity: .30;
}
```

## Extensiones

Algunos navegadores permiten propiedades CSS virtuales, es decir,
propiedades que no son oficiales y únicamente las admite ese navegador.

### Bordes redondeados

-   **Firefox**: `-moz-border-radius`
-   **Safari**: `-webkit-border-radius`

Equivaldría al `border-radius` de CSS3.

``` css
.box {
    background-image: none;
    -moz-border-radius: 1.6em;
    -webkit-border-radius: 1.6em;
    border-radius: 1.6em;
}
```

Podemos indicar los bordes específicos a ser redondeados con las
siguientes propiedades: *-moz-border-radius-topleft* o
*-webkit-border-top-left-radius*, *-moz-border-radius-topright* o
*-webkit-border-top-right-radius*, *-moz-border-radius-bottomleft* o
*-webkit-border-bottom-left-radius*, *-moz-border-radius-bottomright* o
*-webkit-border-bottom-right-radius*.

### Opacidad

Tanto el IE como el Firefox tienen una una extensión que permite cambiar
la opacidad de una div:

-   Internet explorer: `filter:alpha(opacity=`*valor menor de 1*`)`
-   Firefox: `-moz-opacity:`*valor menor de 1*

``` css
.box {
    background-image: url(imagen.gif);
    filter:alpha(opacity=25);
    -moz-opacity:.25;
```

### Enlaces

-   [Mozilla
    Extensions](http://developer.mozilla.org/en/docs/Mozilla_CSS_Extensions)
-   [Mozilla Extensions
    Reference](http://developer.mozilla.org/en/docs/CSS_Reference:Mozilla_Extensions)
-   [Nuevos elementos de
    HTML5](http://www.ibm.com/developerworks/xml/library/x-html5)
