# Xtra PHP

## Iteradores

Para poder crear una clase que almacene una colección de objetos, o
simplemente para que pueda recorrerse con un `foreach` deberemos heredar
de la interface `Iterator`, esta nos obliga a implementar los siguientes
métodos:

-   `void rewind()`, colocar el índice al principio.
-   `current()`, devuelve el objeto actual.
-   `key()`, retorna la clave de la posición actual.
-   `void next()`, coloca el índice en la posición siguiente.
-   `bool valid()`, retorna true/false según si quedan más objetos por
    recorrer.

``` php
class NumberSquared implements Iterator {
    private $start, $end;
    private $cur;

    public function __construct($start, $end) {
        $this->start = $start;
        $this->end = $end;
    }
    public function rewind() {
        $this->cur = $this->start;
    }
    public function key() {
        return $this->cur;
    }
    public function current() {
        return pow($this->cur, 2);
    }
    public function next() {
        $this->cur++;
    }
    public function valid() {
        return $this->cur <= $this->end;
    }
}
```

Existe otra interface llamada `IteratorAggregate`, esta te obliga a
implementar el método `getIterator` que ha de devolver una instancia de
un objeto que implemente `Iterator`. De esa forma, a todo objeto que
implemente `IteratorAggregate` puedes sacarle un iterador que lo
recorra.

## Ficheros

### Ficheros

Las funciones para el acceso a ficheros son:

-   `fopen` abre un fichero. Parámetros: 1. Dirección del fichero; 2.
    Permisos. Retorna el puntero del fichero. Los permisos:
    -   `r` abre el fichero en modo sólo lectura.
    -   `r+` abre el fichero en modo lectura-escritura.
    -   `w` abre el fichero en modo escritura. Si el fichero no existe
        se crea, si existe se elimina su contenido.
    -   `w+` abre el fichero en modo lectura-escritura. Si el fichero no
        existe se crea, si existe se elimina su contenido.
    -   `a` abre el fichero en modo escritura, pero coloca el puntero
        del fichero al final de este. Si el fichero no existe se crea.
    -   `a+` abre el fichero en modo lectura-escritura, colaca el
        puntero del fichero al final de este. Si el fichero no existe se
        crea.
    -   `b` abre el fichero en modo binario. En sistemas Linux esto no
        tiene efecto ya que no se diferencias ficheros binarios\\texto,
        en cambio en Windows es necesario.
-   `fread` lee un bloque de datos de un fichero y lo retorna.
    Parámetros: 1. Puntero del fichero; 2. Bytes que leerá.
-   `fgets` lee una línea de un fichero y la retorna. Parámetros: 1.
    Puntero del fichero.
-   `fwrite` y `fputs` escriben un bloque de datos en un fichero.
    Parámetros: 1. Puntero del fichero; 2: Datos a escribir.
-   `fclose` cierra el fichero. Parámetros: 1. Puntero del fichero.
-   `feof` devuelve true cuando se ha llegado al final de un fichero.
    Parámetros: 1. Puntero del fichero.

//Ejemplo sencillo: * `$file = fopen('hola.txt', 'r');
while (!feof($file)) {
  print fgets($file) . "<br />";
}
fclose($file);
`{.php} *Copia fichero hola.txt en adios.txt: //

``` php
$file1 = fopen('hola.txt', 'r');
$file2 = fopen('adios.txt', 'w');
while (!feof($file1)) 
  fwrite($file2, fgets($file1));
fclose($file1);
fclose($file2);
```

### Acciones en el sistema de archivos

-   `ulink` recibe como parámetro el nombre de un fichero. Eliminará
    este.
-   `rename` recibe como parámetro dos nombres, el primero será un
    nombre de archivo el cual cambiará por el segundo.
-   Funciones para comprobar el estado de un fichero:
    -   `file_exists` se le pasa por parámetro el nombre del fichero e
        indica si este existe.
    -   `is_file`, `is_link` o `is_dir` devuelven true si el fichero
        indicado es lo que preguntamos si es.
-   Funciones para trato con directorios:
    -   `getcwd` devuelve el directorio actual.
    -   `chdir` se le pasa un string que corresponde al directorio
        actual por el que cambiará.
    -   `disk_total_space` devuelve el tamaño total en bytes de la
        partición donde está contenida el directorio que se le pasa por
        parámetro.
    -   `diskfreespace` o `disk_free_space` reciben como parámetro una
        dirección de directorio y devuelven, en bytes, el tamaño libre
        de la partición donde se encuentra.
    -   `scandir` se le pasa un nombre de directorio y devuelve los
        archivos contenidos en él.
    -   Puedes iterar sobre los archivos de un directorio con las
        funciones `opendir`, `readdir`, `rewinddir` y `closedir`.
    -   Existe una clase denominada `dir` que te permiterealizar las
        tareas comunes sobre un directorio utilizando la poo.
-   Funciones para volcar el contenido de un fichero:
    -   `file` se le pasa por parámetro el nombre de un fichero y
        devuelve el contenido de este en una matriz.
    -   `file_get_contents` devuelve el contenido de un fichero en un
        string.
-   Ficheros temporales:
    -   `tmpfile` no recibe parámetros pero devuelve el puntero a un
        archivo creado con nombre aleatorio, cuando este se cierre será
        borrado.
    -   `tempnam` pasandole el directorio escogido y la extensión se
        crea un archivo con nombre aleatorio, este no está abierto y la
        función devuelve su nombre. Se aconseja ubicarlo en una ruta
        donde se borre automáticamente al cabo del tiempo o borrarlo
        manualmente al final del script\\rutina.

## Flujos de datos (streams)

## Bases de datos

### SQLite

### MySQL

:!: Consultar el último id: `msyql_insert_id();`

## XML

## Expresiones Regulares

## Sockets

## Seguridad

## Notas

### Como\...

#### Recoger el contenido de una página externa

``` php
$str = file_get_contents($url);
```

#### Convertir una cadena a utf-8

``` php
$str = utf8_decode($str);
```

### Frameworks

-   [CakePHP](/fw/others/cake)
