# JavaScript (en el navegador)

## Básico

-   [jQuery](/fw/others/jquery), una librería para facilitar, mejorar y
    ampliar el uso de este lenguaje.

### Usar en HTML

Para agregar un script externo a una página html hacemos:

``` html
<script src="scripts/jquery.js" type="text/javascript"></script>
```

Para introducir código directamente en la página:

``` html
<script type="text/javascript">
[[ CODIGO ]]
</script>
```

### Ventana

:?:

-   `window.location.reload()`: Se ejecuta la accion reload de la barra
    de direcciones del navegador. Exactamente como hacer click en el
    boton reload.
-   `history.go(0)`: Se carga la ultima pagina del historico del
    navegador. Claro que esa entrada coincide con la pagina que estamos
    viendo actualmente.
-   `history.back()`: Redirige el navegador a la última página.
-   `window.location.href=window.location.href`: Se ingresa una nueva
    direccion web, que casualmente es la misma de la pagina que estamos
    viendo actualmente.
-   `window.location = path`: Cambia la ruta de la página actual.

### Funciones

-   `alert`: Muestra un mensaje de alerta al usuario.
-   `confirm`: Muestra un mensaje de alerta al usuario con dos opciones:
    aceptar y cancelar. Si el usuario elige aceptar la función retornará
    true.

## Como\...

### JSON

Mirar [combinación de JSON con
JavaScript](/tags/json#combinandolo_con_javascript).

### Descargar datos

Esta es la principal acción que se realiza en una petición AJAX.

#### XMLHttpRequest

En el siguiente ejemplo se descargan datos en formato JSON utilizando el
objeto `XMLHttpRequest`:

``` javascript
var http_request = new XMLHttpRequest();
var url = "./controller.ashx";

http_request.onreadystatechange = handle_json;
http_request.open("GET", url, true);
http_request.send(null);

function handle_json() {
    if (http_request.readyState == 4) {
        if (http_request.status == 200) {
            var json_data = http_request.responseText;
            var the_object = eval("(" + json_data + ")");
        } else {
            alert("Ha habido un problema con la URL.");
        }
        http_request = null;
    }
}
```

1.  Se crea un objeto XMLHttpRequest para conectar a datos externos.
2.  Se inicializa, indicando la función a la que se llamará cuando se
    reciban los datos mediante la propiedad `onreadystatechange` y se
    indica la acción que se hará mediante la función `open` (URL, forma
    de llamada a los datos\...).
3.  Se llama a `send` que hará una petición a la URL indicada.
4.  Cuando se reciban datos se llamará a la función que se ha indicado,
    en ese caso `handle_json`, si el `readyState` es 4 y el `status` 200
    es que todo ha ido bien y podremos recoger los datos de la propiedad
    `responseText`.

### Pequeños \"code snippets\"

#### Impedir cerrar la ventana\\pestaña

En IE podemos utilizar el evento `onbeforeunload`, ya sea desde el mismo
body (`<body onbeforeunload="javascript:OnClose();">`) o agregándolo
dinámicamente:

``` javascript
function window.onload() {
  window.attachEvent("onbeforeunload", OnClose);
}
function OnClose() {
  event.returnValue = "Are you sure you want to close this window?";
}
```

#### Trabajar con iFrames

Acceder al iframe:

``` javascript
document.frames.<id>.location = 'http://www.google.es';
```

Acceder al padre desde el iframe:

``` javascript
parent.funcion(id);
```

#### Saber la resolución de la pantalla

``` javascript
var ancho = screen.width;
var alto = screen.height;
```

#### Copiar al portapapeles

    window.clipboardData.setData('Text', $('#divNombre').text());

## Notas

### Consejos

:!: Deberían ser releidos y reformateados.

-   Recuerda, un script se declara así:

```{=html}
<!-- -->
```
    <script type="text/javascript">
    ...
    </script>

-   No utilizar la función `eval`.
-   Utilizar [JSLINT](http://www.jslint.com/), programa que analiza el
    código js.
-   Poner los scripts js al final de la página.
-   Hay formas más rápidas que un for para construir un string, por
    ejemplo:

```{=html}
<!-- -->
```
    var arr = ['item 1', 'item 2', 'item 3'];  
    var list = '<ul><li>' + arr.join('</li><li>') + '</li></ul>';  

-   Elimina las variables globales, por ejemplo:
    -   Este código\...

```{=html}
<!-- -->
```
    var name = 'Jeffrey';
    var lastName = 'Way';
    function doSomething() {...}
    console.log(name); // Jeffrey -- or window.name

      * Es mejor así...

    var DudeNameSpace = {
       name : 'Jeffrey',
       lastName : 'Way',
       doSomething : function() {...}
    }
    console.log(DudeNameSpace.name); // Jeffrey

-   Usar `{ }` en vez de `new Object()`.
    -   Este código\...

```{=html}
<!-- -->
```
    var o = new Object();
    o.name = 'Jeffrey';
    o.lastName = 'Way';
    o.someFunction = function() {
       console.log(this.name);
    }

      * Es mejor así...

    var o = {
       name: 'Jeffrey',
       lastName = 'Way',
       someFunction : function() {
          console.log(this.name);
       }
    };

      * Para crear un objeto podemos hacerlo ''var o = {};''.
    * Para una lista de variables podemos declararlas de la siguiente forma:

    var someItem = 'some string',
        anotherItem = 'another string',
        oneMoreItem = 'one more string';

-   Para hacer funciones que se autoejecuten las meteremos entre
    parentesis:

```{=html}
<!-- -->
```
    (function doSomething() {
       return {
          name: 'jeff',
          lastName: 'way'
       };
    })();

-   Para parsear JSON utiliza el parser del creador en
    [JSON2](http://www.json.org/json2.js).
