# JavaEE

## Introducción

Una aplicación web en JavaEE tiene una estructura concreta. En la raíz
de la aplicación debe existir el directorio **WEB-INF**; dentro de este
habrá como mínimo dos directorios más **classes** (donde estarán los
compilados de nuestra aplicación) y **lib** (donde importaremos las
librerías para nuestra aplicación). En WEB-INF también incluiremos el
archivo *web.xml* y otros archivos de configuración, también podremos
encontrar la carpeta *src* con el código fuente de la aplicación.

-   \*\* Notas \*\*

Una aplicación web puede ser guardada en un archivo .war que después
podremos subir a nuestro server y que se instalará automáticamente.

## Tecnologías

-   [Servlets](/sp/j2ee/servlets)
-   [JSP](/sp/j2ee/jsp)
-   [JSTL](/sp/j2ee/jstl)

## Páginas de ejemplo

### JSP

``` html
<html>
<body>
<% for (int i=0; i<10; i++) { %>
    Hola mundo!! <br />
<% } %>
</body>
</html>
```

### Servlet

``` java5
package org.miwebapp;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MiServlet extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        java.io.PrintWriter writer = response.getWriter();
        writer.setContentType("text/html");
        for (int i=0; i<20; i++)
            writer.println("Hola munundo!! <br/>");
    }
}
```

### web.xml

``` XML
<?xml version="1.0" encoding="ISO-8859-1"?>
<web-app xmlns="http://java.sun.com/xml/ns/j2ee" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd"
    version="2.4">
    <display-name>jspHello</display-name>
    <description>
        This is my first jsp-app.
    </description>
    <servlet>
    <servlet-name>First</servlet-name>
    <servlet-class>org.miwebapp.MiServlet</servlet-class>
    </servlet>
    <servlet-mapping>
    <servlet-name>First</servlet-name>
    <url-pattern>/prueba_servlet</url-pattern>
    </servlet-mapping>
</web-app>
```

Este web.xml indica que la aplicación tendrá como nombre *jspHello*,
descripción *This is my first jsp-app*. Declara un servlet llamado
*First* que corresponde a la clase *org.miwebapp.MiServlet* y luego lo
enlaza con el nombre *prueba_servlet*. De esta forma para lanzar la
clase MiServlet habría que hacer *\<dirección de la web\>/\<nombre de la
aplicación\>/prueba_servlet*.\
\
![Ejemplo de web.xml](/sp/jsp/web.xml.txt)

## Tomcat

### Configuración

#### Añadir usuarios

En el archivo *conf\\tomcat-users.xml* añadiríamos:

``` xml
<user username="nombre" password="password" roles="manager" />
```

#### Cambiar puerto de la aplicación

En el archivo *conf\\server.xml* se definen cosas como esta; la
siguiente línea es la que indica por qué puerto sirve Tomcat sus
peticines HTTP.

``` xml
<Connector port="8080" protocol="HTTP/1.1" maxThreads="150" connectionTimeout="20000" redirectPort="8443" />
```

### Enlace con Apache

Para poder enlazar correctamente el servidor web Apache y Tomcat, se ha
de tener instalado y activado en el primero el módulo **mod_jk**.\
Necesitaremos crear un archivo de configuración en apache con una
pequeña configuración para tomcat, java y para un worker:

        workers.tomcat_home=/usr/local/apache-tomcat-5.5.16/
        workers.java_home=$JAVA_HOME
        ps=/
        worker.list=default
        worker.default.port=8009
        worker.default.host=localhost
        worker.default.type=ajp13
        worker.default.lbfactor=1

En la configuración de Apache deberemos indicar unos parámetros (por
ejemplo para decir qué archivo estamos utilizando (JkWorkersFile) o
donde se guardarán los logs de la relación Apache-Tomcat:

        JkWorkersFile "conf/workers"
        JkLogFile "logs/mod_jk.log"
        JkLogLevel warn

Ahora, para enlazar una aplicación Tomcat con Apache usaremos la
directiva JkMount para especificar qué archivos debe ejecutar Tomcat.

        JkMount /jsp-examples default
        JkMount /jsp-examples/* default
        JkMount /jsp-examples/*.jsp default

### Notas

-   Cuando se agrega una nueva aplicación a Tomcat, este ha de
    reiniciarse.

## Archivos

-   El libro //Core Servlets and JavaServer

ages// ha sido el usado para los apartados de Servlets y JSP.
