# Apache Web Server

-   El directorio de apache puede ser: */etc/httpd* o */etc/apache2*.
    Según la distribución.
-   En Debian, el ejecutable lo encontrarás en: /usr/sbin

## Ejecutar, acabar, reiniciar

Podrás manipular apache ejecutando ***apache2/bin/httpd*** segido de
**-k** y alguno de los siguientes parámetros:\

    start       Inicia 
    restart     Reinicia
    graceful    Reinicia poco a poco, a medida que acaban las peticiones
    stop        Para el servicio

*Si usas Debian y lo has instalado mediante paquetes, Apache estará en
**/etc/init.d/apache** y se tratará como un servicio (para, por ejemplo,
reiniciar: **/etc/init.d/apache restart***

## Configuración

Archivos de configuración según distribución:

    apache2/conf/httpd.conf
    /etc/apache2/apache2.conf

-   Cada vez que este archivo sea tocado el servidor deberá reiniciar.
-   Si queremos comprobar si el fichero de configuración es correcto
    usaremos: `/usr/sbin/apache2ctl -t` en Debian, en cualquier otra
    busca el ejecutable *apachectl* o *apache2ctl*.
-   Existen dos tipos de configuración: la general (de todo el servidor)
    y la de cada host virtual individualmente (cada web). Para acceder a
    la configuración de un host virtual sólo debemos ir al tag
    *\<VirtualHost\>* correspondiente.
-   Podemos incluir otro fichero de configuración al principal (mediante
    `Include`), de esa forma también será leido y podremos ternerlo
    organizado por secciones\\ficheros:

```{=html}
<!-- -->
```
    Include conf/extra/httpd-userdir.conf

### Configuración General

Directivas:

-   **ServerTokens** Especifica el valor para las cabeceras HTTP.
-   **ServerAdmin** E-Mail al que dirigirse si ocurre algún error de
    servidor.
-   **ServerName** Nombre del servidor y puerto que apache utiliza para
    referirse a sí mismo. Puede ser también introducido dentro de
    \<VirtualHost\>.

```{=html}
<!-- -->
```
    ServerName arturito:80
    ...
    ServerName alfred.isa-geek.net:468

-   **ServerRoot** Ruta del apache.

### Binding

La acción \'binding\' consiste en escuchar por puertos, para ello se usa
la directiva **listen**. Apache te permite escuchar por uno o varios
puertos, elegir a qué IP atenderás\... Apache responderá por cada uno de
los sitios indicados.

-   **Escuchar por el puerto 80:**

```{=html}
<!-- -->
```
    Listen 80

-   **Escuchar por el 80 y el 8080:**

```{=html}
<!-- -->
```
    Listen 80
    Listen 8080

-   **Restringir únicamente a varias IPs:**

```{=html}
<!-- -->
```
    Listen 192.170.2.1:80
    Listen 192.170.2.5:8000

### Directivas de ámbito

Las `scope directives` son las indicadas para configurar el servidor
\'por partes\' específicas. Para ello utilizamos las secciones:

-   \*\* Secciones del sistema de ficheros: \*\*
    -   **\<Directory\>** Especifica directorios.
    -   **\<DirectoryMatch\>** Como \<Directory\>, pero acepta
        expresiones regulares.
    -   **\<Files\>** Especifica ficheros.
    -   **\<FilesMatch\>** Como \<Files\>, pero acepta expresiones
        regulares.

El siguiente código impide el acceso a los ficheros denominados
*private.html*:

    <Files private.html>
    Order allow,deny
    Deny from all
    </Files>

Podemos también combinar estas directivas:

    <Directory /var/web/dir1>
    <Files private.html>
    Order allow,deny
    Deny from all
    </Files>
    </Directory>

-   \*\* Secciones de la web: \*\*
    -   **\<Location\>** Se utiliza cuando queremos configurar la
        dirección de un elemento por url. Usaremos este método cuando la
        página web sea creada dinámicamente.
    -   **\<LocationMatch\>** Como \<Location\>, pero acepta expresiones
        regulares.

Mediante estas limitamos la concfiguración a zonas específicas de
nuestro server. Pueden estar anidadas.

#### Secciones condicionales

También existen directivas de ámbito condicionales, si sus condiciones
son ciertas será válida la configuración que contienen:

-   **\<IfDefine\>** Según los parámetros indicados al inicio.
-   **\<IfModule *modulo*\>** Según si el módulo está cargado.

Estas también pueden pueden realizar comprobaciones negativas usando
**!**.

    <IfModule prefork.c>
    StartServers         5
    MinSpareServers      5
    MaxSpareServers     10
    MaxClients          20
    MaxRequestsPerChild  0
    </IfModule>

### .htaccess

Es el nombre por defecto del fichero de Acceso (puede ser cambiado, o
asignado otros nombres, en la directiva *AccessFileName*). Este fichero
se utiliza para especificar unas directivas concretas a un sitio. La
directiva *AllowOverride* de la configuración principal indica que tipo
de directivas pueden ser sobreescritas por los ficheros de acceso.

### Directorios personales

En Linux, un Sistema Operativo donde pueden existir varios usuarios, es
posible que cada uno de ellos tenga su propia web personal. Para ello se
ha de usar la directiva **UserDir** del módulo *mod_userdir*.\
Se puede indicar de formas distintas:

-   **UserDir public_html** Dentro del directorio de cada usuario se
    usará el `public_html` como directorio web.
-   **UserDir /var/html** En `/var/html` debe existir una carpeta con el
    nombre de cada usuario la cual será su directorio web.
-   **UserDir /var/www/\*/docs** En `/var/html` debe existir una carpeta
    con el nombre de cada usuario y dentro de esta una con nombre `docs`
    la cual será su directorio web.

A partir de entonces cada usuario podrá acceder a su web mediante la
dirección: `host/~usuario`.

    http://127.0.0.1/~alfred

### Hosts Virtuales

Existen dos tipos de Hosts Virtuales, los que se basan en nombres y los
que se basan en direcciones. A los primeros Apache devolverá la página
web adecuada según el nombre indicado, respecto a los que se basan en
IP, las webs que devolverán vendrán dadas por la IP que realiza la
petición.\
Para usar VH (VirtualHosts) basados en nombres tendrás que especificar
que dirección y puerto se usarán para atender las peticiones
(`NameVirtualHost`), aunque también puede ser indicado con un \*. A
partir de ahí ya podemos crear un bloque VH con el argumento al
NameVirtualHost correspondiente, dentro de cada uno de estos bloques,
como mínimo, necesitarás definir:

-   **ServerName** Para designar el nombre.
-   **ServerRoot** Para indicar la dirección de los archivos de la web.

La directiva **ServerAlias** permitirá que a un VH pueda accederse
mediante varios nombres.\
Cuando llega una petición, el servidor verifica si se está usando una
dirección IP que coincide con el valor de NameVirtualHost. Si es así,
buscará en cada sección \<VirtualHost\> la IP que coincida e intentará
encontrar si el valor de la directiva ServerName o de la directiva
ServerAlias coincide con el nombre del sitio web de la petición. Si
encuentra una coincidencia, usa la configuración de ese servidor. Si no
la encuentra, usa el primer host virtual de la lista cuya dirección IP
coincida con el de la petición.

### Logs

En la directiva *ErrorLog* podremos configurar el archivo log (de
registro) principal.\
La directiva *LogLevel* se utiliza para controlar los tipos de errores
según su gravedad.\
Cuando llegue el momento de cambiar de archivos de log (porque, por
ejemplo, los que tienes actualmente se han llenado demasiado) el
siguiente conjunto de comandos puede ser el más adecuado:

    mv access_log access_log.old
    mv error_log error_log.old
    apachectl graceful
    sleep 600
    gzip access_log.old error_log.old

También podemos indicar un log específico por VirtualHost que tengamos
configurado incluyendo las directivas anteriores dentro del contenedor
*\<VirtualHost\>*.

## Directivas

### Acceso

Estas se encuentran en el módulo *mod_access* y son usadas junto con las
\<Directory\>, \<File\>, \<Location\> y el archivo .htaccess.

-   **Allow** Indica los que están permitidos. Se usa generalmente en la
    directiva \<Directory\> y podemos indicar `all` o un nombre de host
    (este puede ser un nombre de host, una IP o un rango de IPs).

```{=html}
<!-- -->
```
    Allow from all
    Allow from 192.168.1

-   **Deny** Indica los que no tienen permitido acceder al server. Su
    sintaxis es la misma que Allow.
-   **Order** Indica como han de tratarse Allow y Deny. Básicamente en
    qué orden se evaluarán,
    -   `Deny, Allow` El acceso por defecto es permitido. Se evalua
        primero la directiva Deny.
    -   `Allow, Deny` El acceso por defecto es restringido. Se evalua
        primero la directiva Allow.

```{=html}
<!-- -->
```
    Order Allow,Deny
    Allow from apache.org
    Deny from foo.apache.org

### Otras directivas

#### Alias

Esta directiva nos permite redireccionar una url; de esta forma podemos
enlazar un directorio que no se encuentra en nuestra web.\
Haciendo:

    Alias /jorge /mnt/www/jorge

Podremos acceder a: `http://127.0.0.1/jorge`

## Modulos

Apache es un servidor modular, esto significa que podemos añadirle
propiedades añadiendole nuevos módulos. Al instalarse, Apache se instala
con dos módulos por defecto: *core.c* y *mod_so.c*; son los
correspondientes al núcleo. Luego, a parte, pueden añadirse más, de
forma estática, al instalar Apache, indicando qué módulos deben de ser
añadidos. O compilándolos y añandiéndolos usando apxs, a estos se les
llama módulos DSO (Dynamic Shared Object).\
Podemos listar módulos haciendo: *ejecutable apache* -l

    ./apache2 -l

Para Construir e instalar un módulo, pongamos `mod_foo.c`, como un DSO
con nombre nombre `mod_foo.so` con apxs haremos:

    $ cd /path/to/3rdparty
    $ apxs -c mod_foo.c
    $ apxs -i -a -n foo mod_foo.la 

Una vez tengamos un módulo compilado mediante *apxs* podremos cargarlo
al iniciar Apache utilizando la directiva *LoadModule*.

## En Debian

El Apache del sistema Debian proviene de ciertas herramientas para
facilitar algunas tareas:

-   Los comandos **a2enmod** y **a2dismod** son muy útiles para
    activar\\desactivar módulos. Para ello se utilizan dos carpetas
    `mods-enabled` y `mods-available`. Se añaden ficheros de
    configuración .load en mods-available y cuando queramos activar un
    módulo ejecutaremos el a2enmod seguido del nombre del módulo, se
    creará un enlace en mods-enabled que será usado por apache para
    activarlo.
-   Los comandos **a2ensite** y **a2dissite** son muy útiles para
    activar\\desactivar sitios. Para ello se utilizan dos carpetas
    `sites-enabled` y `sites-available`. Se añaden ficheros de
    configuración de sitios en sites-available y cuando queramos activar
    ese sitio ejecutaremos el a2ensite seguido del nombre del site, se
    creará un enlace en sites-enabled que será usado por apache para
    activarlo.
-   El comando **apache2ctl** es una buena herramienta para lanzar,
    detener, reiniciar\... cómdamente apache.
-   Los logs se encuentran en `/var/log/apache2`

## Notas

-   En la carpeta de la aplicación encontraremos un archivo llamado
    *apxs* que es la utilidad de apache para construir\\instalar
    modulos.
-   Si queremos que sea indiferente que apache lea un index.html o un
    index.htm únicamente deberemos hacer en la carpeta en la que están
    un enlace simbólico: `ln -s index.htm index.html`.
-   La página web que por defecto saca apache la encontramos en
    */var/www*.
-   Términos que pueden ser interesantes:
    1.  Filter: Programas que manejan la transmisión de datos. Tanto las
        de entrada (input filters) como las de salida (output filters).
        Los módulos pueden ser filters.
    2.  Handlers: La acción que debe de realizar Apache con los
        ficheros, cómo deben de ser tratados estos.
-   En Debian encontrarás que los archivos de configuración se
    encuentran en la carpeta */etc/apache2*, existen varios archivos y
    directorios. Una mejor aclaración la encontrarás, evidentemente, en
    el README. El archivo principal es `apache2.conf`, los puertos de
    escucha se encuentran en `ports.conf`. Hay dos carpetas para sites y
    para módulos, para los activos y para los existentes; por ejemplo,
    para los sites existe el `site-avaiable` donde están todos los
    archivos de configuración para VirtualHost. En `site-enabled` se
    encuentran enlaces simbólicos hacia ellos, realmente los se importan
    al archivo de configuración son los de site-enabled.
-   Para comprobar qué puertos de escuchas, hosts virtuales\... tiene
    activos Apache, lanzaremos su ejecutable con el parámetro -S:
    `apache2 -S`
-   Apache se ejecuta como el usuario: `www-data`, aunque esto puede ser
    editado con *User* y *Group*. Ejemplo: *User alfred*.
-   En Debian, las sesiones de PHP5, las funciones de sqlite\... Son
    módulos que pueden ser añadidos de forma sencilla únicamente
    instalando sus paquetes.

## In a nutshell

### Seguridad

#### Deniega el acceso al HD pero no a la carpeta /var/www/htdocs

    <Directory />
    Options SymLinksIfOwnerMatch
    AllowOverride None

    Order Deny,Allow
    Deny from all
    </Directory>

    DocumentRoot "/var/www/htdocs"
    <Directory "/var/www/htdocs">
    Options Indexes FollowSymLinks MultiViews
    AllowOverride None

    Order allow,deny
    Allow from all
    </Directory>

#### Deniega el acceso a ficheros que empiecen por .

\... Como por ejemplo `.htaccess`.

    <Files ~ "^\.">
    Order allow,deny
    Deny from all
    </Files>
    <Files ~ "^\.\.?$">
    Order allow,deny
    Allow from all
    </Files>

### Proxy configuration

    <VirtualHost *:80>
            ServerName serveis.bcn.coop

            Alias /static /srv/Coopolis.back-office/static

            <Directory /srv/Coopolis.back-office/static>
                Require all granted
            </Directory>

            ProxyPass /static !
            ProxyPass / http://localhost:8000/
            ProxyPassReverse / http://localhost:8000/
    </VirtualHost>

## Archivos

-   ![Chuleta de apache](/sistemas/apache/apache_chuleta.pdf)
