# Bash Scripting

## Básico

Para crar un script deberás:

1.  Crear un archivo de texto
2.  Poner las órdenes en el orden deseado después de una primera línea:
    `#!/bin/bash`
3.  Dar a ese fichero permiso de ejecución `chmod +x fichero`

### Variables

-   Definimos variables de la forma más sencilla: `nombre='valor`\'
-   Podemos mostrar una variable llamando al comando `echo` y colocando
    el símbolo `$` delante del nombre de esta: `echo $myvar`
-   Podemos mostrar el valor de una variable dentro de una cadena
    utilizando: `${variable}`. El siguiente ejemplo mostraría:
    `Hola caracola!`

``` bash
myvar = 'caracola'
echo Hola ${myvar}!
```

-   Si queremos asignar un comando a una variable utilizaremos el
    *accent tancat*: `` var = `pwd` ``. O mediante `$(comando)`:
    `var = $(pwd)`

### Control de flujo

#### IF

    if [ condición ]
    then
       código
    elif [ condición ]
    then
       código
    else
       código
    fi

### Argumentos del ejecutable

-   Para saber cuantos argumentos han sido pasados haremos: `$#`
-   Para acceder al nombre del fichero ejecutable haremos: `$0`
-   Para acceder a cada uno de los parámetros: `$x` (siendo x un número
    a partir de 1)

## Comandos útiles

  --------------- -----------------------------------------------------------------
  basename path   Pasándole una ruta de un fichero devuelve el nombre del fichero
  dirname path    Devuelve el directorio de esa ruta
  --------------- -----------------------------------------------------------------

## Notas

-   Visita la [biblioteca, apartado de Bash
    Scripting](/sistemas/linux/biblioteca#bash_scripting)
-   Links:
    -   <http://www.cyberciti.biz/nixcraft/linux/docs/uniqlinuxfeatures/lsst/>
    -   <http://www.freeos.com/guides/lsst/>
