# Perl

## Nociones básicas

### Sintaxis

-   Comentario:

``` perl
# Hola mundo
```

-   Declaración de variables:

``` perl
$nombre = "Alfred";
$edad = 25;
my $x;
local $y;
```

Con **my** y **local** restringimos el acceso a los bloques de código
(ya sean if, bucles, o simples bloques\...). Con **my** limitamos la
variable al bloque de código donde estamos. Con **local** la variable
estará disponible dentro de ese bloque (y en los internos).

-   Imprimir algo:

``` perl
print ("hola");
print ($nombre);
print ("hola ", $nombre);
print ("hola ", $nombre, " hola");
print ("hola \$nombre $nombre");    # Imprime 'hola \$nombre Alfred'
print ('\$edad = $edad');           # Imprime '\$edad = $edad'
print "hola ".$nombre." el guapo";  # No son necesarios los parentesis
```

-   Ejecutar comandos de sistema (shell):

``` perl
print (`date`);
$date = `date`;
</perl>
  * Bucles:
<code perl>
# while de toda la vida
while ($edad != 0) {
    print ("hola\n");
    $edad--;
}

# lo contrario al while, sólo imprimirá un hola (el correspondiente a $edad = 25)
until ($edad == 24) {
    print ("hola");
    $edad--;
}

if ($edad > 24) {
    print ("No puede tener el carnet jove");
} elsif ($edad == 24) {
    print ("Este es el último año de carnet jove");
} else {
    print ("Puede tener el carnet jove");
}
```

\*\* También existen en *do\...while* y el *do\...until*. También
*unless,* que es lo contrario del if\*\*

-   Puedes declarar bloques de código que se ejecutarán linealmente:

``` perl
{
 print ("hola\n");
}
{
 print ("adios");
}
```

### Carácteres especiales

### Funciones especiales

-   **chop *variable*** Quita los espacios extraños de los extremos de
    una variable. Por ejemplo, si cogemos en una variable la fecha de
    sistema (`` $date = `date`; ``) y luego la imprimimos en medio de
    una cadena, esta será cortado en líneas (\$date tendrá un salto de
    línea al final). Si antes de ello hacemos `chop $date` nos quedará
    perfecto.

## Notas

-   La extensión por defecto para un archivo con código perl es: .pl
-   El directorio donde se encuentra el ejecutable en Linux es:
    */usr/bin/perl*. Por lo tanto, al crear un script sin IDE alguno que
    nos ayude se ha de poner como primera línea:

```{=html}
<!-- -->
```
    #! /usr/bin/perl

## Archivos

-   ![Variables Especiales](/script/perl/special_variables.pdf)
