# JavaScript

-   [Referencia de los distintos
    objetos](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects).

## Básico

### Tipos de datos

#### Strings

Acciones:

-   `str1 + str2`, concatenar.

Propiedades:

-   `length`: Devuelve la longitud de la cadena.

Métodos:

-   `charAt(indice)`: Devuelve el carácter situado en la posición
    especificada por \'indice\'.
-   `lastIndexOf(cadena_buscada, indice)`: Devuelve la posición de la
    última ocurrencia de \'cadena_buscada\' dentro de la cadena actual,
    a partir de la posición dada por \'indice\', y buscando hacia atrás.
    Este último argumento es opcional y, si se omite, la busqueda
    comienza por el último carácter de la cadena.
-   `split(separador)`; Parte la cadena en un array de caracteres. Si el
    carácter separador no se encuentra, devuelve un array con un sólo
    elemento que coincide con la cadena original.
-   `substring(primer_Indice,segundo_Indice)`: Devuelve la subcadena que
    comienza en la posición \'primer_Indice + 1\' y que finaliza en la
    posición \'segundo_Indice\'. Si \'primer_Indice\' es mayor que
    \'segundo_Indice\', empieza por \'segundo_Indice + 1\' y termina en
    \'primer_Indice\'. Si hacemos las cuentas a partir de 0, entonces es
    la cadena que comienza en \'primer_Indice\' y termina en
    \'segundo_Indice - 1\' (o bien \'segundo_Indice\' y
    \'primer_Indice - 1\' si el primero es mayor que el segundo).
-   `toLowerCase()`: Devuelve la cadena en minúsculas.
-   `toUpperCase()`: Devuelve la cadena en mayúsculas.
-   Para el `format` mira los [snippets](/script/jssintaxis&#snippets).

Parsear a:

-   Int: `parseInt`.

#### Arrays

Creación:

``` javascript
var x = new Array(); // x es un nuevo array
var x = new Array(5); // x es un nuevo array de 5 elementos
var x = [5]; // x es un nuevo array de 5 elementos
var x = new Array(); x[0] = "car"; // x es un nuevo array y se le ha asignado un valor
```

Añadir un elemento al final del array:

``` javascript
myArray[myArray.length] = someValue;
```

Saber si un elemento existe en el array:

``` javascript
function existsOnArray (value, array) {
    return (array.indexOf(value) != -1);
}
```

Propiedades:

-   `length`, devuelve el tamaño del array.

Métodos:

-   `push`, añade uno o más elementos al final del array, devuelve el
    nuevo tamaño.ray.
-   `join`, une los elementos del array en un string a partir de un
    separador.

#### Arrays asociativos

``` javascript
new myArray = new Array();
myArray["abc"] = 200;
myArray["xyz"] = 300;

var myArray = { "abc":200, "xyz": 300};
alert(myArray["abc"]); // output: 200

for(key in myArray) {
   alert("key " + key
         + " has value "
         + myArray[key]);
}
```

### Bucles

-   El foreach es\...

```{=html}
<!-- -->
```
    for(key in object) {
       if(object.hasOwnProperty(key) {
          ...then do something...
       }
    }

### Condicionales

-   Utiliza `===` y `!==` en vez de `==` ya que mejora el trabajo con
    elementos tipados.

## Orientado a Objetos

Hay que tener en cuenta las dos siguientes frases al programar con
JavaScript:

1.  Los objetos son diccionarios.
2.  Los métodos son objetos.

#### Diccionarios

Los objetos en JavaScript funcionan como pares de clave-valor, como si
fuesen diccionarios.

``` javascript
var p = new Object();
p.x = 3;
p.y = 5;
message.innerHTML = p.x + "," + p.y; 
```

Es lo mismo que:

``` javascript
var p = new Object();
p["x"] = 3;
p["y"] = 5;
message.innerHTML = p["x"] + "," + p.y; 
```

#### Funciones como variables

El hecho que un método (o sea, una función) sea un objeto significa que
puede ser asignada a una variable:

``` javascript
var p = new Object();
p["x"] = 3;
p.y = 5;
p["print"] = function() {
  message.innerHTML = p.x + "," + p.y;
}
```

Otro ejemplo más claro de como asignar una funcion a un objeto:

``` javascript
function add(point) {
      return point.x + point.y;
}

var myFunc = add
var p = { x: 1, y:1 };
var result = myFunc(p);
// Devolverá 2
alert(result); 
```

#### Objetos literales

Existe otra forma de definir objetos en JavaScript (denominada literal),
esta es directa y no requiere de declaración:

``` javascript
var p =
{
    x : 5,
    y : 3,
    print : function() { message.innerHTML = p.x + ',' + p.y; }
}
p.print(); 
```

O\...

``` javascript
var person =
{
    name: "Scott Allen",     createdDate: new Date()
    website: "OdeToCode.com",
    address: { state: "MD", postalCode: "21044" },
};

alert(person.address.state);
alert(person.createdDate); 
```

#### Métodos de un objeto

``` javascript
var point1 =
{
    x: 3,
    y: 5,
    add: function(otherPoint)
         {
             this.x = this.x + otherPoint.x;
             this.y = this.y + otherPoint.y;
         }
};
```

#### Constructores

``` javascript
function Point(x,y)
{
    this.x = x;
    this.y = y;
}
var p1 = new Point(3,5);
alert(p1.x, p1.y); 
```

O lo siguiente también sería válido:

``` javascript
function Point(x,y)
{
    this.x = x;
    this.y = y;
    this.add = function(point2)
        {
            this.x += point2.x;
            this.y += point2.y;
        }
}
var p1 = new Point(3,5);
```

## Avanzado

### Closures

Podemos crear una función parametrizando su código interno y
devolviéndola para que luego sea usada con sus propios argumentos:

``` javascript
var buildfn = function(csvfile, headers) {
    var response2console = function(result, response) {
        if (result instanceof Error) {
            console.error('Error: ' + util.format(response.message));
        } else {
            console.error("Wrote %s", csvfile);
            fs.writeFileSync(csvfile, result);
            csv2console(csvfile, headers);
        }
    };
    return response2console;
};
```

## Notas

-   Para eliminar un objeto de memoria haremos: `delete objeto;`. No se
    borra el objeto sino la referencia.

### Snippets

#### String.Format

``` javascript
String.format = function() {
    var s = arguments[0];
    for (var i = 0; i < arguments.length - 1; i++) {
        var reg = new RegExp("\\{" + i + "\\}", "gm");
        s = s.replace(reg, arguments[i + 1]);
    }
    return s;
}
```
