# Web Management

## MySQL

### Backups

    backup: # mysqldump -u root -p[root_password] [database_name] > dumpfilename.sql

    restore:# mysql -u root -p[root_password] [database_name] < dumpfilename.sql

Examples

    mysqldump -u root -p[root_password] [database_name] > dumpfilename.sql
    mysql -u root -ptmppassword sugarcrm < /tmp/sugarcrm.sql

## Apache

### Add new site to a new server

We will add the new site copying the values from the default site in
`/etc/apache2/sites-available`. Now we will change the values of the
virtual host (they all can be at 80 port).

    <VirtualHost *:80>
        # The ServerName directive sets the request scheme, hostname and port that
        # the server uses to identify itself. This is used when creating
        # redirection URLs. In the context of virtual hosts, the ServerName
        # specifies what hostname must appear in the request's Host: header to
        # match this virtual host. For the default virtual host (this file) this
        # value is not decisive as it is used as a last resort host regardless.
        # However, you must set it for any further virtual host explicitly.
        ServerName davidberga.cat

        ServerAdmin webmaster@localhost
        DocumentRoot /var/www/html2

        # Available loglevels: trace8, ..., trace1, debug, info, notice, warn,
        # error, crit, alert, emerg.
        # It is also possible to configure the loglevel for particular
        # modules, e.g.
        #LogLevel info ssl:warn

        ErrorLog ${APACHE_LOG_DIR}/error.log
        CustomLog ${APACHE_LOG_DIR}/access.log combined

        # For most configuration files from conf-available/, which are
        # enabled or disabled at a global level, it is possible to
        # include a line for only one particular virtual host. For example the
        # following line enables the CGI configuration for this host only
        # after it has been globally disabled with "a2disconf".
        #Include conf-available/serve-cgi-bin.conf
    </VirtualHost>

It will depend on the server name.\
We will use then the `a2ensite name_of_config` to enable it.\
And\... `service apache2 reload`

### Several ServerName\'s

    <VirtualHost *:80>

        Servername wiki.lan 
        ServerAlias wiki

        [...]

    </Virtualhost>

Or\...

    <VirtualHost *>
        DocumentRoot /Sites/example
        ServerName www.example.com
        ServerAlias *.example.com *.x-ample.com *.xmpl.com *.egzample.com
    </VirtualHost>

### Restart

    $ service apache2 restart

### Check if config is right

    $ apachectl configtest

### Enable SSL

You will need to enable the ssl mod:

    $ a2enmod ssl

Also, you will need to check that the VirtualHost config allows ssl:

    <IfModule mod_ssl.c>
    <VirtualHost _default_:443>

Then\...

-   ![](/wiki2/webmanagement/install_an_ssl_certificate_-_wikihow.pdf)
-   ![](/wiki2/webmanagement/how_to_create_a_self-signed_certificate.pdf)

### Install for PHP

    apt-get install php5-sqlite php5-gd php5-curl

### Auth

-   <http://doc.norang.ca/apache-basic-auth.html>

## Domain registration

We should change the CNAME table and give an A type to a new record.

## Certbot

<https://certbot.eff.org/>

Para añadir un certificado para una web:

    certbot --apache

Para updatear:

    certbot renew

El update lo puedes poner en un crontab:

    20 2,14 * * *   certbot renew

### Acciones

Listar certificados:

     docker exec -ti nginx /usr/local/bin/certbot-auto certificates
