# FicusJS

    import { createComponent } from 'https://cdn.skypack.dev/ficusjs@3/component'
    import { html, renderer } from 'https://cdn.skypack.dev/@ficusjs/renderers@3/uhtml'

    // https://docs.ficusjs.org/
    // https://github.com/WebReflection/uhtml/blob/master/DOCUMENTATION.md

    createComponent('record-form', {
      renderer,
      props: {
        uuid: {
          type: String,
          required: true
        },
        detail: {
            type: String,
            required: true
        },
        amount: {
            type: Number,
            required: true
        }
      },
      state () {
        return {
          uuid: this.props.uuid,
          detail: this.props.detail,
          amount: this.props.amount
        }
      },
      onSave (e) {
        this.emit('onsave', this.state)
      },
      onCancel (e) {
        this.emit('oncancel', {
          uuid: this.props.uuid,
          detail: this.props.detail,
          amount: this.props.amount
        })
      },
      updatedContent (e, options) {
        this.state[e.target.name] = e.target.value
      },
      render () {
        return html`
          <div class="account-table-row">
            <div class="row-content">
              <input type="text" class="detail" name="detail" onchange=${[this.updatedContent, {"name": "detail"}]} .value=${this.state.detail}></input>
              <input type="number" class="amount" name="amount" onchange=${[this.updatedContent, {"name": "amount"}]} .value=${this.state.amount}></input>
            </div>
            <div class="row-menu">
              <div>
                <span class="feather" style="background-image: url('/static/icons/save.svg')" @click=${this.onSave} />
                <span class="feather" style="background-image: url('/static/icons/x-square.svg')" @click=${this.onCancel} />
              </div>
            </div>
          </div>
        `
      },
    })
