# Vue and JS

## Basic

We can do this in html file (after this we should include our script):

    <vue-app>[[ message ]]</vue-app>

    new Vue({
      el: 'vue-app',
      delimiters: ['[[', ']]'],
      data: {
        message: "Hello Vue! caca de la vaca!"
      }
    });

O con una inline template:

    new Vue({
      el: 'vue-app',
      data: {
        message: "Hello Vue! caca de la vaca!"
      },
      template: `<div>{{ message }}</div>`
    });

### Using require

    "use strict";

    require(
      ['../static/js/test.js'], 
      function() {
        new Vue({
          el: 'user-app',
          template: `
        <div>
          {{ message }} <button-counter></button-counter>
        </div>`,
          data: {
            message: "Hello Vue! caca de la vaca!"
          }
        });
    });

test.js:

    "use strict";

    Vue.component('button-counter', {
        data: function () {
            return {
                count: 0
            }
        },
        template: '<button v-on:click="count++">You clicked me {{ count }} times.</button>'
    })
