# Useful Elm

## Base structure

    module Happened exposing (..)

    import Browser
    import Html exposing (div, text)

    main =
      Browser.element
        { init = init
        , update = update
        , subscriptions = subscriptions
        , view = view
        }

    type alias Model = 
        { number: Int
        , flags: Flags
        }

    initialModel : Flags -> Model
    initialModel flags = { number = 0, flags = flags }

    subscriptions : Model -> Sub Msg
    subscriptions model =
      Sub.none

    type alias Flags = 
        { value : String
        }

    init : Flags -> (Model, Cmd Msg)
    init flags = (initialModel flags, Cmd.none)

    type Msg = NoMsg

    update msg model =
      case msg of
        NoMsg -> (model, Cmd.none)

    view model = div [] [text ("hello " ++ model.flags.value) ]

    <div id="elm-app"></div>
    <script src="{% dstatic 'js/elm-components.js' %}"></script>
    <script>
      var app = Elm.Happened.init({
        node: document.getElementById("elm-app"),
        flags: {
            value: "world"
        }
      });
    </script>

## Language toolbox

### Packages

Install a package:

     elm install elm/json

Useful packages:

-   elm/json, for json encoding and decoding.
-   elm/http, for requests.

## Libraries

-   [elm-spa](https://www.elm-spa.dev/)

## Code Examples

### SPA

-   <https://github.com/rtfeldman/elm-spa-example>
-   ![](/wiki2/elm/elm-spa-example-master.zip){.align-center}

### eCommerce

-   ![](https://github.com/lucamug/elm-ecommerce){.align-center}
-   ![](/wiki2/elm/elm-ecommerce-master.zip){.align-center}

## How to\...

### Add several modules to one js script?

We will need two \"main\" modules. Then compile it like this:

    elm make src/Main1.elm src/Main2.elm --output=main.js

After this you can call it like this:

    <div id="elm-app1"></div>
    <div id="elm-app2"></div>

    <script src="main.js"></script>
    <script>
      var app = Elm.Main1.init({
        node: document.getElementById("elm-app1")
      });
      var app2 = Elm.Main2.init({
        node: document.getElementById("elm-app2")
      });
    </script>
