# Supervisor

## Basics

### Install

    sudo apt-get install supervisor 

### Configure

In path `/etc/supervisor/supervisord.conf` we can configure it for any
user:

    [unix_http_server]
    ;file=/var/run/supervisor.sock ; (the path to the socket file)
    file=/tmp/supervisor.sock ; (the path to the socket file)
    chmod=0777 ; sockef file mode (default 0700)

### Start\\Stop the service

    $ service supervisor stop
    $ service supervisor start

### Management

-   supervisorctl status
-   supervisorctl start process
-   supervisorctl stop process

### Adding programs

Add a configuration file .conf in `/etc/supervisor/conf.d` with a
content similar to:

    [program:cat]
    command=/bin/cat
    process_name=%(program_name)s
    numprocs=1
    directory=/tmp
    umask=022
    priority=999
    autostart=true
    autorestart=true
    startsecs=10
    startretries=3
    exitcodes=0,2
    stopsignal=TERM
    stopwaitsecs=10
    user=chrism
    redirect_stderr=false
    stdout_logfile=/a/path
    stdout_logfile_maxbytes=1MB
    stdout_logfile_backups=10
    stdout_capture_maxbytes=1MB
    stderr_logfile=/a/path
    stderr_logfile_maxbytes=1MB
    stderr_logfile_backups=10
    stderr_capture_maxbytes=1MB
    environment=A="1",B="2"
    serverurl=AUTO

#### After adding a program

    $ supervisorctl reread
    $ supervisorctl update

## Eventos

Los eventos en Supervisor son mensajes de un tipo X que lanza
Supervisord. Los posibles actualmente son:
<http://supervisord.org/events.html#event-types>

Para ello sólo has de definir un listener (que no es más que otro
programa) para supervisor. Se le dice qué programa es el receptor y qué
eventos:

    [eventlistener:mylistener]
    command=my_custom_listener.py
    events=PROCESS_STATE,TICK_60

El código de un listener puede ser el siguiente ( :!: date cuenta que
sigue un protocolo de `OK` -\> `READY`):

``` python
import sys

def write_stdout(s):
    sys.stdout.write(s)
    sys.stdout.flush()

def write_stderr(s):
    sys.stderr.write(s)
    sys.stderr.flush()

def main():
    while 1:
        write_stdout('READY\n') # transition from ACKNOWLEDGED to READY
        line = sys.stdin.readline()  # read header line from stdin
        write_stderr(line) # print it out to stderr
        headers = dict([ x.split(':') for x in line.split() ])
        data = sys.stdin.read(int(headers['len'])) # read the event payload
        write_stderr(data) # print the event payload to stderr
        write_stdout('RESULT 2\nOK') # transition from READY to ACKNOWLEDGED

if __name__ == '__main__':
    main()
    import sys
```

[Superlance](http://pypi.python.org/pypi/superlance) es un grupo de
listeners ya programados que pueden ser utilizados.
