# Shortcuts

## Docker

Start Postgres

    docker run --rm -d -p 5432:5432 -v /home/alfred/tmp/postgresdata:/var/lib/postgresql/data -v /tmp:/tmp --name postgres -e POSTGRES_PASSWORD=mysecretpassword postgres

Logs:

    docker logs --since 30s -f <container_name_or_id>
    docker logs --tail 20 -f <container_name_or_id>

## Git

    git config credential.helper store

## Linux

### Links

-   [linux_commands#apt](/wiki2/linux_commands#apt)-get
    install\|reinstall\|update

#### Date

Format date in the way you like it:

    $(date +%y%m%d)

### Cheat

You can define the next alias:

    function cheat() { curl cht.sh/$1 }

With it you can launch something like `cheat rename` to see its
examples.

### Find in files

`grep -iRl "your-text-to-find" ./`\
Here are the switches: **-i** ignore text case, **-R** recursively
search files in subdirectories, **-l** show file names instead of file
contents portions.

### Rename

    rename 's/perl/pl/' *.perl
    # Sample outputs:
    # 'bar.perl' renamed to 'bar.pl'
    # 'foo.perl' renamed to 'foo.pl'
    # Lowercase all files and folders in current directory
    rename 'y/A-Z/a-z/' *

### tar

    # Compress a folder
    tar -zcvf archive-name.tar.gz directory-name

    # Extract it
    tar -xzf bar.tar.gz

### zip & unzip

    zip -r folder.zip ./folder

### HTTP Local server in python

    python3 -m http.server 8000

### Merge two folders

    rsync -a /path/to/source/ /path/to/destination

## PostgreSQL

    \q: exit.
    \list or \l: list all databases
    \dt: list all tables in the current database
    \connect database_name to switch database
    $ export PGPASSWORD=mysecretpassword && psql -h 127.0.0.1 -U postgres
    $ export PGPASSWORD=mysecretpassword && dropdb -h 127.0.0.1 -U postgres fok
    $ export PGPASSWORD=mysecretpassword && createdb -T template0 -h 127.0.0.1 -U postgres fok
    $ psql restored_database < database.bak
    $ pg_dump postgres > postgres_db.bak
    $ pg_dumpall > backup_file

## SQL

Update

    UPDATE T
       SET C1 = 9,
           C3 = 4
     WHERE C2 = 'a'

## Mongo

    docker run -p  27017:27017 -v /home/alfred/mongodata:/data/db  -d mongo

# Python Gotchas

-   [Creación de entornos virtuales con
    venv](/wiki2/python3#venv_para_crear_entornos_virtuales)

## Serving your current directory by HTTP

For Python 3 run:

    python3 -m http.server

For Python 2 run:

    python -m SimpleHTTPServer

## Prettify JSON

    cat file.json | python -m json.tool
