# Flask Testing

## Basic

### Live Server

``` python
import urllib2
from flask import Flask
from flask.ext.testing import LiveServerTestCase

class MyTest(LiveServerTestCase):

    def create_app(self):
        app = Flask(__name__)
        app.config['TESTING'] = True
        # Default port is 5000
        app.config['LIVESERVER_PORT'] = 8943
        return app

    def test_server_is_up_and_running(self):
        response = urllib2.urlopen(self.get_server_url())
        self.assertEqual(response.code, 200)
```

### Not rendering templates

You need to set `render_templates` to False. Also use
`assert_template_used` to know if the template was rendered.

``` python
class TestNotRenderTemplates(TestCase):

    render_templates = False

    def test_assert_mytemplate_used(self):
        response = self.client.get("/template/")

        self.assert_template_used('mytemplate.html')
```

### Testing SQL Alchemy

``` python
from flask.ext.testing import TestCase

from myapp import create_app, db

class MyTest(TestCase):

    SQLALCHEMY_DATABASE_URI = "sqlite://"
    TESTING = True

    def create_app(self):

        # pass in test configuration
        return create_app(self)

    def setUp(self):

        db.create_all()

    def tearDown(self):

        db.session.remove()
        db.drop_all()
```
