# Programming links

## Blogs

## Languages

### C and C++

-   [C++
    Guidelines](https://github.com/isocpp/CppCoreGuidelines/blob/master/CppCoreGuidelines.md)
-   [C++ hints](https://www.reddit.com/r/cpp/comments/3lcqcu/c_hints/)
-   [Pythonic
    C++](http://preshing.com/20141202/cpp-has-become-more-pythonic/)
-   [Tips for
    C](https://medium.com/@marinamakarova/26-tips-on-c-programming-61cb54900234)

#### Libraries and snippets

-   [Garbage collection with
    cello](http://libcello.org/learn/garbage-collection)
-   [Thread pool in
    C++11](https://github.com/nbsdx/ThreadPool/blob/master/ThreadPool.h)

### Python

-   [Tips &
    tricks](https://codefisher.org/catch/blog/2015/01/27/python-tips-tricks-and-idioms/)
-   [Tips &
    traps](https://www.airpair.com/python/posts/python-tips-and-traps)
-   <http://mezzanine.jupo.org/> CMS for Django

Resources

-   <http://pycoders.com/>, weekly news.
-   <http://blog.notdot.net/tag/damn-cool-algorithms>, damn cool
    algorithms.

Blogs

-   [Good computer vision articles](http://blog.christianperone.com/).

Videos

-   <https://www.youtube.com/channel/UCgxzjK6GuOHVKR_08TT4hJQ>, PyCon
    2015

## Globals

-   [MVC
    book](https://stefanoborini.gitbooks.io/modelviewcontroller/content/index.html)
-   <http://logstash.net/> log system
-   <http://nwjs.io/> write apps in node
-   <http://littlebits.cc/> used in gamestart
-   <https://github.com/jbochi/bullock> and
    <https://github.com/RealGeeks/sherlock> Distributed mutex systems
-   <http://streaming.medialab-prado.es/> Medialab videos
-   <http://libcinder.org/> Librería de código creativo

## OpenGL

-   Tutoriales
    -   <http://ogldev.atspace.co.uk/index.html>
    -   <http://www.opengl-tutorial.org/>

# Artículos how to

-   [Compilar unreal engine en
    Linux](https://wiki.unrealengine.com/Building_On_Linux)

## iPython

-   [Render iPython books on
    github](https://blog.jupyter.org/2015/05/07/rendering-notebooks-on-github/)

## Python

-   [Use Electron (Atom library) as
    GUI](https://www.fyears.org/2015/06/electron-as-gui-of-python-apps.html)
-   [Gesture
    typing](http://nbviewer.ipython.org/url/norvig.com/ipython/Gesture%20Typing.ipynb)
-   [Create Python
    Dashboards](http://multithreaded.stitchfix.com/blog/2015/07/16/pyxley/)
-   [Flask
    videos](https://www.youtube.com/playlist?list=PLLjmbh6XPGK4ISY747FUHXEl9lBxre4mM)
-   [Automatizar usando
    selenium](https://geekinsideyou.wordpress.com/2015/05/17/automating-stuff-using-python-and-selenium/)
-   [Automatizar](http://geeksta.net/geeklog/automating-browser-tasks-without-distraction-on-ubuntu/)

## OpenGL & Graphics

-   [Create a GUI with
    OGL](http://voxels.blogspot.com.es/2015/07/opengl-game-gui-widgets-with-source.html)
-   [YouTube Channel with
    tutorials](https://www.youtube.com/playlist?list=PLSPw4ASQYyymu3PfG9gxywSPghnSMiOAW)

## Programación funcional

-   [Book](http://drboolean.gitbooks.io/mostly-adequate-guide/)

## Image processing Tool

-   <http://imageplay.io/>

## Web Dev

-   [Notifications](https://developer.cdn.mozilla.net/media/uploads/demos/e/l/elfoxero/c17223c414d8ddafb7808972b5617d9e/html5-notifications_1400214081_demo_package/index.html#en)
