# NodeJS

## Básico

`console.log("hello");` mostrará un mensaje por pantalla.

`node fichero[.js]` ejecutará el fichero.

Para importar un paquete de un módulo (como por ejemplo express):

    var express = require('express');

Install dependencies

    npm install

Start the development script using a environment variable:

    PORT=8080 npm run dev

The script is defined in packages.json:

      "scripts": {
        "dev": "nodemon -w src --exec \"babel-node src --presets es2015,stage-0\"",
        "build": "babel src -s -D -d dist --presets es2015,stage-0",
        "start": "node dist",
        "prestart": "npm run -s build",
        "test": "eslint src"
      },

### Packages.json

#### Dependencies

Puedes añadir paquetes a la parte de \"dependencies\". El `*` significa
coger la última.

    "dependencies": {
      "express":"*"
    }

`npm install` instalará todos los paquetes en dependencies.

#### npm install

    -g : para instalar en el global (necesitas ser root)
    --save : para guardar en el packages.json
    --save-dev : para guardar en el packages.json como dependencia de dev

## Notes

Si lo instalas en Ubuntu el comando será `nodejs`, para que use el
global (`node`) haz:

    # ln -s /usr/bin/nodejs /usr/bin/node

### Best way to swap node versions

The continuous exchange of NodeJS environments in your machine can bring
some issues or be too uncomfortable. The best way to manage this is the
`nvm` tool.

-   <https://github.com/nvm-sh/nvm>

There you will find the installation procedure to follow. Once you have
it, the use is as it follows:

    $ nvm use 16
    Now using node v16.9.1 (npm v7.21.1)
    $ node -v
    v16.9.1
    $ nvm use 14
    Now using node v14.18.0 (npm v6.14.15)
    $ node -v
    v14.18.0
    $ nvm install 12
    Now using node v12.22.6 (npm v6.14.5)
    $ node -v
    v12.22.6

-   An alternative is [asdf](https://asdf-vm.com/).
