# NGINX

## Basics

Reload configuration inside docker:

    docker exec -ti nginxcontainer nginx -s reload

## Example rules

### Deny all requests that contain \"wp-cron.php\" anywhere

      location ~ wp-cron.php? {
          deny all;
          access_log off;
          log_not_found off;
          return 444;
      }

## Enable sites

    $ ln -s /etc/nginx/sites-available/seximes /etc/nginx/sites-enabled/
    $ service nginx restart

## NGINX + PHP

Install the dependences:

`sudo apt-get install php5-common php5-cli php5-fpm`

Install nginx:

`sudo apt-get install nginx`

Start nginx:

`sudo service nginx start`

Test that it\'s working (should see \"Welcome to nginx!\")

`sudo service nginx stop`

In your nginx site configuration (/etc/nginx/sites-available/default),
uncomment the lines in the server {} section starting with
`listen for ipv4 / ipv6 both.`

scroll down to where it says `location ~ .php {` and uncomment lines so
it looks like this:

    location ~ \.php$ {
      fastcgi_split_path_info ^(.+\.php)(/.+)$;
      fastcgi_pass unix:/var/run/php5-fpm.sock;
      fastcgi_index index.php;
      include fastcgi_params;
    }

\'\'sudo service php5-fpm restart

sudo service nginx restart\'\'

Your default web root is located at `/usr/share/nginx/www`

To install mysql: `sudo apt-get install mysql-server php5-mysql`

### Note

:?: At this point I do not know if this works for a 502 Bad Gateway
error but\...

    fastcgi_buffer_size 128k;
    fastcgi_buffers 8 128k;
    fastcgi_busy_buffers_size 128k;
    fastcgi_temp_file_write_size 128k;

### Example for php7

You have to ensure that php7 is working:

    service --status-all
    service php7.0-fpm status

You can put a `check.php` file on your site:

    <?php phpinfo(); ?>

    server {
      server_name mantis.codi.coop;
      root /srv/mantis;

      location ~ \.php$ {
            try_files $uri =404;
            fastcgi_split_path_info ^(.+\.php)(/.+)$;
            fastcgi_pass unix:/var/run/php/php7.0-fpm.sock;
            fastcgi_index index.php;
            fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
            include fastcgi_params;

            fastcgi_buffer_size 128k;
            fastcgi_buffers 8 128k;
            fastcgi_busy_buffers_size 128k;
            fastcgi_temp_file_write_size 128k;
        }

    }

## Notes

### With wordpress

#### Accept post name as permalink

In the `server` section inside the configuration part:

    # unless the request is for a valid file, send to bootstrap
    if (!-e $request_filename)
    {
       rewrite ^(.+)$ /index.php?q=$1 last;
    }

### Redirect to Flask app (in Gunicorn)

    server {
            listen 80;
            listen [::]:80;
            server_name alfred.is-a-rockstar.com;
            location / {
                    proxy_pass http://127.0.0.1:5000;
                    proxy_set_header Host $host;
                    proxy_set_header X-Real-IP $remote_addr;
                    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
            }
    }

### Redirect www to another

    # /etc/nginx/sites-available/exploreflask.com

    # Redirect www.exploreflask.com to exploreflask.com
    server {
            server_name www.exploreflask.com;
            rewrite ^ http://exploreflask.com/ permanent;
    }

    # Handle requests to exploreflask.com on port 80
    server {
            listen 80;
            server_name exploreflask.com;

                    # Handle all locations
            location / {
                            # Pass the request to Gunicorn
                    proxy_pass http://127.0.0.1:8000;

                    # Set some HTTP headers so that our app knows where the
                    # request really came from
                    proxy_set_header Host $host;
                    proxy_set_header X-Real-IP $remote_addr;
                    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
            }
    }

### Having several hosts

You can have several \"server\", for example:

    server {
            listen 80;
            listen [::]:80;
            server_name alfred.is-a-rockstar.com;
            location / {
                    proxy_pass http://127.0.0.1:5000;
                    proxy_set_header Host $host;
                    proxy_set_header X-Real-IP $remote_addr;
                    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
            }
    }

and

    server {
        listen 80;
        listen [::]:80;

        root /var/www/seximes;
        index index.html index.htm;

        server_name seximes.cat;

        location / {
            try_files $uri $uri/ =404;
        }
    }

### Example reverse proxy configuration

    server {
        server_name wiki.sir.gtd;
        location / {
            proxy_pass http://dokuwiki:80;
            proxy_set_header Host $host;
            proxy_set_header Accept-Encoding "";
            proxy_set_header X-Real-IP $remote_addr;
            proxy_buffering off;
        }

        listen 80;
    }
