# Jupyter notebooks

## Basic

Current examples: [Github -\> iPython -\> iPython -\>
examples](https://github.com/ipython/ipython/tree/a8165da9102a62203c824f8cb59988e188fc6032/examples)

Ctrl+ENTER en una celda la ejecuta y se queda en dicha celda. Con
Shift + ENTER la ejecuta y pasa a la siguiente.

Puedes cambiar el tipo en Cell -\> Cell Type. Por ejemplo código,
markdown, texto\...

`!ls` to launch a shell command. It\'s possible to do `a = !ls`. You can
access to a python variable with `$`. Something like `touch $file_path`

No hace falta usar la función `print`.

Puedes descargar con formatos tales como python, latex, pdf\...

### Mostrar gráficos

Si vas a usar matplotlib has de añadir la línea `%matplotlib inline`
para que los gráficos se añadan al notebook.

## Usar pandas

`df = pd.read_csv('file.csv', header=2)` lee el fichero file.csv
esquivando las dos primeras líneas. Más parámetros a la hora de leer:

-   `indx_col=(0, 2, 3)`, indica que las columnas 0, 2 y 3 son índices.
-   `parse_dates=[3]` indica que la columna 3 es fecha.

`df.head()` cogerá la cabecera.

`db['2000']` cogerá la columna 2000.

`df.plot()` mostrará los datos en un gráfico.

`le = df.groupby(level=0).first().transpose()` agrupa por la primera
columna y muestra la matriz girada.

`le.columns` mostrará los nombres de columnas.

Coger solo unas columnas:

    le[['1990', '2000', '2010']]

Para agrupar una columna por intervalos de, por ejemplo días, y luego
contarlos usaríamos: `data['columns'].resample('D').count()`. Con \'h\'
seria para horas.

### Panda data structures

-   Series: 1D = numpy.ndarray = similar to a dictionary (indice +
    valor)
-   DataFrame: 2D = numpy.ndarray = similar to a Excel spreadsheet
    (columns have different array)
-   Multiindex series o dataframe: higher dimensional data

Crear una serie:

    a = pd.Series({'a': 33, 'b': 334})

Crear un dataframe:

    # a = previous example 'a' variable
    b = pd.Dataframe(pd.dataframe({'age': a, 'test': {'a': 55, 'b': 53})

To select rows:

    b.loc('b')
    b.loc(['a', 'b'])

Select by column:

    df.loc(:, ['b'])

`iloc` is another way to select with indexes. Also slicing:
`df.iloc[2:5]` que es lo mismo que `df(2:5)`

También se puede escoger booleanos: `df > 500` devolverá una lista de
cabecera y true\\false. Puede hacerse una consulta algo así:
`daily_crimes(daily_crimes > 500).count()` que devuelve solo el número
que es mayor que 500. Otra forma:
`daily(daily_crimes(daily_crimes > 500 & daily_crimes < 600).count()`

`count` and `sum` are other userful functions.

`crimes = cirmes.set_index(['primary'], append=True)` añade la columna
primary al indice. Es decir añade un level al indice.

### Reshaping

-   pivot_table (to select just the rows and columns you want)
-   stack / unstack (to add more levels to a multiindex)
-   groupby (like sql group by)
-   resample (for time intervals)

Añadir una columna (occourences) con valores de 1:
`crimes['occourences'] = np.ones(len(crimes))`. Ahora podrías crear un
índice quitándote los repetidos con:
`crimes.occourences.groupby(level=(0, 1)).sum()`

`fillna(0)` method llena los valores que son NaN con 0.

Consultar: `crimes_by_type.loc[:, ['THEFT', 'HOMICIDE']]['2016']`.
Mostrará los crímenes theft y homicidio en 2016. Para quitar ruido
(porque estarán puestos por hora) los ponemos por día:
`crimes_by_type.loc[:, ['THEFT', 'HOMICIDE']]['2016'].ersample('D').sum().plot()`

## ipywidgets

<https://ipywidgets.readthedocs.io>

[List of
widges](https://ipywidgets.readthedocs.io/en/stable/examples/Widget%20List.html)

Are for creating dynamic notebooks.

    from ipywidgets import interact

    @interact(crime_type = crimetype.columns)
    def plot_cart(crime_type):
      crime_by_type.loc[:, crime_type]...

## Jupyter Notebooks ─ Special cases

### \... And Google Spreadsheets

-   ![](/wiki2/jupyter/google_spreadsheet.zip)
-   <https://socraticowl.com/post/integrate-google-sheets-and-jupyter-notebooks/>
