# GIT Pipelines and How To\'s

## Merge a feature branch

    git checkout master
    # Merge with squash so it's clean
    git merge feature-branch master --squash
    git checkout master
    git commit -a
    # Remove local and remote branch
    git branch -d feature-branch
    git push origin --delete feature-branch

## How to\...

### Configure an ssh key

Generate an ssh key without passphrase or it will keep asking you for
for it. You need to upload the public key to the server. Then, configure
the host in your ssh config:

    Host bitbucket.org
    IdentityFile ~/.ssh/keys/gitkey

This will allow you to do:

    git clone git@bitbucket.org:gfms/shopifyapp.git

ℹ️ If you want to debug, you can do:

    ssh -vvv git@git.alfredgg.dev

### This could be a good config

    Host git.alfredgg.dev
    Port 222
    IdentityFile ~/.ssh/keys/gitkey
    User git

### Commits

### \... get a commit from another branch?

    git cherry-pick <commit>

### Merges

#### \... abort a merge?

    git merge --abort

### Reset

#### \... make a big reset?

Also cleaning new files

    git clean -f -d 
    git reset --hard
