# C++ Notes

## Notes about the language

-   **C++11** is the ISO C++ standard ratified in 2011. The previous
    standard is often referred to as C++98 or C++03; the differences
    between C++98 and C++03 are so few and so technical that they ought
    not concern users. C++14 is the informal name for a recent revision
    of the C++ standard. It is intended to be a small extension over
    C++11, featuring mainly bug fixes and small improvements.
-   **Differences between a class and a struct** in C++ are that structs
    have default public members and bases and classes have default
    private members and bases. Both classes and structs can have a
    mixture of public and private members, can use inheritance, and can
    have member functions. Classes create a namespace that also
    encapsulate the functions for manipulating its data elements.
    Classes may not be used when interfacing with C, because C does not
    have a concept of classes.

### Maps

-   ![Maps](/wiki2/cpp/maps.pdf)

## Libraries

### Use

Lets consider your `/usr/local/lib/libYARP_OS.a`. What you can do is,
have `-L/usr/local/lib/` in your makefile as one of the variables. And
then you can have `-lYARP_SO` appended to the LDLIBS.

-L is for path to the lib and -l is the lib name here `libYARP_OS`.a
will be passed as `-lYARP_OS`. On command line you would do something
like: `gcc -o main main.c -L/usr/local/lib/ -lYARP_SO`. This should give
you an idea.

## C++11

### Auto

``` cpp
ofRectangle rectangle = ofGetCurrentViewport();
//is the same as
auto rectangle = ofGetCurrentViewport();

//and

const ofRectangle rectangle = ofGetCurrentViewport();
//is the same as
const auto rectangle = ofGetCurrentViewport();

float x = rectangle.x;
//is the same as
auto x = rectangle.x;

//and

float & x = rectangle.x;
//is the same as
auto & x = rectangle.x;
```

### Foreach

``` cpp
for (auto mySelfie : mySelfies) { ... }
// To use a reference rather than a copy
for(auto & mySelfie : mySelfies) { ... }
```

### Override

This does not produces an error:

``` cpp
class BuildingProjectionMapper {
public:
//...
    virtual void mapTheGreekColumns();
//...
};

class AutoBuildingProjectionMapper : public BuildingProjectionMapper {
public:
    void mapTheGreekColums(); // woops, I spelt column incorrectly
};
```

To solve this:

``` cpp
class AutoBuildingProjectionMapper : public BuildingProjectionMapper {
public:
    void mapTheGreekColums() override;
};
```

## Tips

-   Do not use `this` inside of a constructor.
