# PHP

## Lo básico

Todo código de php se escribe entre `<? ?>` o entre `<?php ?>`

``` php
<HTML>
<BODY>
Veamos qué ocurre cuando... <br />
<strong>
<?php print "Hello world!"; ?>
</strong>
<br /> Uooooo!!!
</BODY>
</HTML>
```

A partir de aquí puedes hacer cosas como empotrar código html en php:

``` php
<HTML>
<BODY>
<strong>
<?php for ($i=0; $i<10; $i++) { ?>
Hola <br />
<?php } ?>
</strong>
</BODY>
</HTML>
```

Los comentarios en código php pueden ser:

-   `//` para una línea.
-   `#` para una línea.
-   `/* ... */` para varias líneas.

### Variables

``` php
$a = $b + 3;
$b = "Hello world";
$c = 44;
$d = 3.14;
```

#### Arrays

-   En PHP los índices de los arrays pueden ser integers o strings.
-   Para indicar que una variable es un array haremos:
    `$variable = array();`. Indicando dentro de los parentesis todos y
    cada uno de sus elementos:
-   Distintas declaraciones:

``` php
$a = array(58, 25, 300);                           // Indices: 0, 1 y 2. Valores respectivos: 58, 25 y 300.
$b = array(0 => 58, 1 => 25, 2 => 300, 65 => 22);  // Indices: 0, 1, 2 y 65. Valores respectivos: 58, 25, 300 y 22.
$c = array("uno" => 1, "dos" => 2);                // Indices: uno y dos. Valores respectivos: 1 y 2
$d = array();                                      // Array vacío.
```

-   Para acceder a los elementos de un array haremos:
    `$variable[índice]`
-   Podemos ampliar el tamaño del array variablemente haciendo:
    `$variable[indice_nuevo] = valor;`, esto añade otro índice y le
    asigna ese valor.
-   Podemos anidar arrays:
    `$variable = array(array(1, 2, 3), array(4, 5, 6));`
-   Para saber el tamaño del array `$a` haremos: `$n = count($a)` y en
    `$n` se nos pondrá un integer que indicará su tamaño.

#### Equivalencia booleana

Un `false`, qué equivale en otras variables?

-   Integer: *0*
-   String: *\"0\"* o *\"\"*
-   Decimal: *0.0*
-   Array: Si no contiene ningún elemento.
-   Null: Siempre será false.
-   Objeto: Siempre será true.

#### Variables indirectas

Podemos crear una variable asignando el nombre que tiene otra por valor.
Para ello haríamos algo así:

    $variable = "nombre_de_nueva_variable";
    $$variable = "asignación del valor de la nueva variable";
    print ($nombre_de_nueva_variable); // Saldría: asignación del valor de la nueva variable ''

Por ejemplo, el siguiente código imprime \"hola qué tal?\":

``` php
$var = "John";
$$var = "hola qué tal?";
print $John;
```

#### Casting

Como siempre, para pasar de un tipo de datos a otro. Sólo hemos de poner
delante, y entre parentesis: *int, float, real, double, string, bool,
array* u *object*.

``` php
$str = "5";
$num = (int) $str;
```

#### Asignación por referencia

En php también podemos asignar por referencia, como si de punteros se
tratase:

``` php
$name = "Judy";
$name_alias = &$name;
$name_alias = "Jonathan";
print $name;
```

Este código muestra \"Jonathan\".

#### Globales

Desde cualquier parte del script podemos acceder a un array cargado en
memoria llamado `$GLOBALS`, este se inicializa cada vez que se carga una
página en memoria; la gracia está en usar nombres de variables que
puedan ser accedidos desde clases, funciones\...

``` php
$var = "numSons";
$GLOBALS[$var] = 4;
...
print $GLOBALS["numSons"];
```

### Constantes

Para declarar constantes utilizamos la función define:
`define ("nombre", valor);`

``` php
define("MI_ERROR", 0);
...
if ($retorno = MI_ERROR) print ("fallo!!");
```

### Condiciones

if

``` php
if ($b < 3)
  printf("B is less than 3\n");
elseif ($b > 3)
  printf("B is more than 3\n");
else
  printf("B is greater than or equal to 3\n");
```

switch, case

``` php
switch ($b) {        {
  case 1:
   printf("one\n");
   break;
  case 2:
   printf("two\n");
   break;
  default:
   printf("none of the above\n");
   break;
}
```

Asignación booleana

``` php
$b = ($a == 1) ? 3 : 5;
```

#### Operador de identidad, o los tres iguales

A veces una función que tiene un uso puede ser usada para un uso
alternativo, como es la `strpos` que retorna el número de posición donde
está el carácter indicado, pero que si no lo encuentra esta retorna
`false` y si quieres distinguir este boolean y el integer tendrás que
utilizar el operador identidad: === , o su negativo !==.\
En el ejemplo se comprueba si en una cadena existe o no, en la posición
que sea, una arroba:

``` php
if (strpos(strEMail, '@') === false) 
    print 'No existe arroba!';
```

### Bucles

-   `while (condicion) { ... }`
-   `do { ... } while (condicion)`
-   `for (inicio; condición de ejecución; fin) { ... }`

#### foreach

foreach (array as varTmp)

``` php
$jugadores = array("John", "Barbara", "Bill", "Nancy");
print  "Los jugadores son: <br />";
foreach ($jugadores as $valor) {
       print "$valor <br />";
}
```

foreach (array as varTmpClave =\> varTmpValor)

``` php
$jugadores = array("John", "Barbara", "Bill", "Nancy");
print  "Los jugadores son: <br />";
foreach ($jugadores as $ind => $valor) {
       print "$ind = $valor <br />";
}
```

### Funciones

Funciones simples:

``` php
function prueba () {
  echo ("Llamada a prueba!");
  $valor = 3;
  return $valor;
}
echo (prueba());
```

Funciones con parámetros:

``` php
function sumaDos ($num) {
  return $num + 2;
}
```

Funciones con parámetros por defecto (Muestra: *45*):

``` php
function sumaDos ($num = 2) {
  return $num + 2;
}
printf(sumaDos());
printf(sumaDos(3));
```

Funciones con variables estáticas, las cuales sólo son definidas la
primera vez que se llaman, las siguientes veces no volverá a definirla
(Muestra: *455*):

``` php
function numero () {
 static $first = true;
 if ($first) {
   $first = false; 
   return 4;
 }
 return 5;
}
print(numero());
print(numero());
print(numero());
```

Funciones que devuelven valores por referencia (Muestra: *4*):

``` php
function &get_global_variable($name) {
    return $GLOBALS[$name];
}
$value =& get_global_variable("num");
```

Funciones que reciben parámetros por referencia:

``` php
function cuadrado (&$num) {
 $num = $num * $num;
}
$n = 2;
cuadrado($n);
print $n;
```

## Elementos predefinidos

### Variables predefinidas

Aunque encontrarás la lista completa y mejor explicada
[aquí](http://es.php.net/reserved.variables), repasaremos la lista de
variables globales predefinidas:\
*Para utilizarlas, por ejemplo \$\_SERVER -\> SERVER_NAME, sería:*
`print $_SERVER["SERVER_NAME"];`

-   \$\_SERVER
    -   SERVER_NAME: Indica el nombre del servidor que ejecuta el
        script.
    -   REQUEST_METHOD: El método de petición con el que se llamó a la
        página.
    -   QUERY_STRING: Cadena de consulta con la que se accedió a la
        página.
    -   DOCUMENT_ROOT: Directorio raíz bajo el que se ejecuta el script.
    -   REMOTE_PORT
    -   REMOTE_ADDR
    -   SCRIPT_FILENAME: Ruta absoluta.
    -   SCRIPT_NAME: Nombre del documento.
-   \$\_GET: Recoge los datos enviados con GET. [Ver
    formularios](/sp/php#formularios)
-   \$\_POST: Recoge los datos enviados con POST. [Ver
    formularios](/sp/php#formularios)
-   \$\_REQUEST: Recoge los datos enviados o con POST o con GET.
-   \$\_COOKIE
-   \$\_ENV
-   \$\_SESSION
-   \$GLOBALS

### Funciones predefinidas

-   `phpinfo` muestra información sobre la instalación de php en esa
    máquina.
-   `print`, `printf` y `echo` reciben un string, este se mostrará por
    pantalla.
    -   Si el string pasado es con comillas dobles mostrará concatenados
        los valores de las variables que estén escritas dentro de este.
    -   Si el string es con comillas simples no hará caso a las
        secuencias de escape (\\n, \\t\...).
    -   Para que printf te formatee un decimal:
        `printf("%.2f\n", 1100.621);`, esto mostraría *1100.62*
-   `isset` recibe por parámetro una variable, si esta está asignada
    devuelve `true`, si no `false`.
-   `unset` recibe por parámetro una variable, lo que hace es borrar su
    valor dejándola \"inasignada\" (insincera???).
-   `print_r` recibe por parámetro un array y lo imprime todo seguido.
-   `eval` recibe por parámetro un string, este lo ejecuta como si de
    código se tratase.
-   `include` no es una función propiamente dicha; se la llama junto con
    un string, este string corresponde a un fichero que se incluye (en
    código html o php) en el que se está ejecutando.
-   `require` y `require_once`, son funciones idénticas que hacen lo
    mismo que `include` (también se les pasa por parámetro un string del
    fichero a incrustar).
    -   La diferencia entre `require` e `include` es que este último
        trata los errores como warnings. El `require` detiene el proceso
        del script (Fatal Error).
    -   `require_once` es un `require` que sólo se ejecuta una vez. Si
        se ponen varios `require` la página se ejecutará tantas veces
        como puesto esté, con `require_once` sólo la primera vez.
-   `die`, recibe un string, acaba la ejecución del script PHP mostrando
    el texto pasado por parámetro.
-   `sleep` y `usleep` retardan la ejecución del programa, el primero
    (sleep) en segundos y el segundo en microsegundos.

``` php
<?php 
phpinfo();
...
if (isset($a)) print "Variable no asignada";
include "function.php";
?>

```

### Funciones numéricas

-   `is_numeric` indica si la variable que se le pase por parámetro es
    un integer.
-   Redondear y acortar decimales:

``` php
$number = round(2.4);   // Redondea: $number = 2
$number = ceil(2.4);    // Redondea hacia arriba: $number = 3
$number = floor(2.4);   // Redondea hacia abajo: $number = 2
// ... //
$number = 56.9415;
$final = round($number, 2);   // Acorta decimales: $final = 56.94
```

-   Generar valores aleatorios entre \$a y \$b: `mt_rand($a, $b);`
-   La función `number_format` devuelve un string con el integer que se
    le pasa pero formateado.

``` php
$number = 1234.56;
print number_format($number, 2);                 // Muestra: 1,234.56
print number_format($number, 2, '@', '#');       // Muestra: 1#234@56
```

### Funciones para arrays

-   `reset`, no recibe ningún parámetro, resetea el puntero interno del
    array. Has de llamarlo siempre antes de utilizar el list\\each.
-   `each`, recibe por parámetro un array (A), muestra el elemento
    actual al que apunta el puntero interno de este y lo avanza un
    puesto. Devuelve un array (B) de cuatro indices: *0, 1, key* y
    *value*. Los indices de B *key* y *0* tienen el mismo valor: el
    índice dentro del array A del elemento actual; los *value* y *1*
    tienen el valor.
-   `list` recibe por parámetros una serie de variables. Un array se
    igualará a él (¿?, ya lo sé\...) y la list asignará por orden
    (correspondiente al orden de parámetro) los elementos a las
    variables.

//Ejemplo de uso del list: (Muestra: JohnBarbaraBill) *
`$players = array("John", "Barbara", "Bill", "Nancy");
list($a, $b, $c) = $players;
print $a;
print $b;
print $c;
`{.php} *Ejemplo de uso del list, each y reset: //

``` php
$players = array("John", "Barbara", "Bill", "Nancy");
reset($players);
while (list($idx, $val) = each($players))
    print "$idx: $val <br />";
?>
```

-   `sort` función a la que le pasas por parámetro un array. Después de
    la llamada a esta función el array estará ordenado.
-   `implode` recibe dos parámetros, un string y un array, devuelve un
    string donde están unidos todos los elementos del array usando como
    separador el primer parámetro.
-   Para crear un array a partir de un rango utilizamos la función
    range, por ejemplo:
    -   `$array = range(2, 52);` Crea un array con sus elementos
        internos de valores: 2, 3, 4, 5\... 51, 52.
    -   `$array = range(2, 52, 3);` Crea un array con sus elementos
        internos de valores: 2, 4, 6\... 50, 52.

:!: Eliminar elementos y demás\...

### Trato con Strings

-   Para acceder a los carácteres de un string se tratará al string como
    un array: `$a = $str[1];` \<- Asigna en \$a el segundo carácter de
    \$str
-   Para concatenar strings lo haremos mediante un punto:
    `$a = "hola" . " caracola";` \<- \$a tiene como valor \"hola
    caracola\".
-   `strlen` recibe un string y devuelve un entero con su tamaño.
-   Para saber en qué posición de un string existe un carácter:
    `strpos($string, 'c');`
-   Para saber si en un string existe un carácter:
    `strpos($string, 'c');` comparandolo mediante el operador de
    identidad.
-   Para sacar un substring: `substring($string, $inicio, $final);`
-   Para obtener un nuevo string con un substring reemplazado de un
    string inicial:
    `substr_replace($old_string, $new_substring, $start);`
-   Eliminar los espacios en blanco de los costados de un string:
    `trim, rtrim, ltrim`.

#### wordwrap

La función `wordwrap` facilita el trabajo con strings largos. Su
sintaxis es:\
`string wordwrap ( string cadena [, int ancho [, string ruptura [, bool corte]]] )`\
Siendo *cadena* el string con el que trabajamos, *ancho* la cantidad de
carácteres que se permiten por línea, *ruptura* el string que
colocaremos hallá donde rompamos la cadena y *corte* si cortaremos en
medio de las palabras o no.

-   Nos permite trabajar con una cadena de más de una línea.

``` php
$s = "Four score and seven years ago our fathers brought forth 
on this continent a new nation, conceived in liberty and
dedicated to the proposition that all men are created equal.";
print "<pre>\n".wordwrap($s)."\n</pre>";
```

-   Nos permite dividir un texto largo

``` php
$texto = "El veloz murcielago hindo comia feliz cardillo y kiwi.";
$nuevo_texto = wordwrap($texto, 20, "<br />\n");
echo $nuevo_texto;
```

### Trato con datos de fecha\\hora

## POO

### Clases y objetos

Definición de una clase:

``` php
class claseA {
    private $name;
    function setName($name) {
        $this->name = $name;
    }
    function getName() {
        return $this->name;
    }
};
```

Declaración de un objeto y acceso a sus métodos y variables:

``` php
$obj1 = new claseA ();
$obj1->setName("Juan");
print $obj1->getName();
```

Como podemos ver en PHP la sintaxis es muy parecida a C++. Para acceder
a los métodos utilizamos -\>. También vemos que existe el puntero
`$this` para referenciar al objeto de esta clase, pero date cuen que con
las propiedades\\métodos que llama no se usan `$`. Pero\... Los objetos
son tratados como referencias o por valores? Veamoslo:

``` php
$obj1 = new claseA ();
$obj1->setName("Juan");
$obj2 = $obj1;
$obj2->setName("Pedro");
print $obj1->getName();
```

Este código devuelve *Pedro*, es decir, son referencias.\
Otra cosa!! Como no, también existe el polimorfismo. Sí, eso de poder
llamar a varios métodos con el mismo nombre pero con distintos
parámetros.\
PHP no es un lenguaje tipado, pero cuando jugamos con objetos y clases
sí que podemos restringir que una función sólo acepte objetos de un tipo
por parámetro (añadiendo el tipo antes del nombre del parámetro):

``` php
function foo (miClase $obj) { ...
```

### Constructores

Existen dos formas de crear un constructor a una clase:

-   Forma tradicional: una función con el mismo nombre que la clase.
-   Utilizando la función: `__construct`.

Es decir, o con la función `claseA`:

``` php
class claseA {
    private $name;
    function claseA ($name) {
        $this->name=$name;
    }
...
```

O con la función `__construct`:

``` php
class claseA {
    private $name;
    function __construct($name) {
        $this->name = $name;
    }
...
```

Si una clase declarase las dos funciones sólo se usaría la función
`__construct` quedando la otra renegada como una función cualquiera.

### Destructores

Para definir un destructor a una clase crearemos un método llamado
`__destruct`, este método se llamará cuando asignemos NULL a un objeto o
cuando acabe el script de php:

``` php
class claseA {
...
  function __destruct () {
    print "Destruido!";
  }
...
$obj1 = NULL;
```

Este código muestra *Destruido!\"*.

### Clonadores

Como los objetos se copian por referencia probablemente nos interese una
forma de copiar objetos, para ello existe la función `__clone`. Se llama
cuando hacemos algo parecido a lo siguiente:

``` php
$obj1 = clone $obj2;
```

Esto copia en \$obj1 un objeto de iguales características que \$obj2.\
Pero podemos sustituir el método `__clone`:

``` php
function __clone () {
  $this->idx ++;
}
Ahora, al hacer el ''clone'', el $obj1 tiene el índice una unidad mayor que $obj2.
```

### Modificadores de acceso

-   public
-   private
-   protected

Tanto para las propiedades como para los métodos.

``` php
public function tal {...
private function cual {...
protected $pascual;
```

### Modificador static

Podemos declarar variables estáticas, para ello utilizaremos el
modificador `static`:

``` php
class claseB {
  private static $valor;
  public static function Escribe () { ...
  ...
```

Para acceder a una variable o método estáticos existen dos formas:

-   La tradicional: `nombreClase::nombreElemento`
-   La de dentro de la clase: `self::nombreElemento`

Por ejemplo, para llamar al método desde fuera de la clase (a la
propiedad no podemos, es privada (pero si fuese pública podríamos de la
misma forma)):

``` php
claseB::Escribe();
```

Y para llamarlos a los dos desde dentro:

``` php
 self::Escribe();
 print self::$valor;
```

### Modificador const

Como en C++ puedes crear constantes dentro de clases, variables que
quedan en memoria una sola vez (como las estáticas) pero que no cambian
de valor en la ejecución. Para ello usa el modificador \'const\':

``` php
class claseC {
  const RED = "Red";
...
```

Para acceder a una variable constante lo haríamos como si de una
estática se tratase: `nombreClase::nombrePropiedad` o
`self::nombrePropiedad`.

### Herencia e interfaces

Se realiza como en Java, para clases usamos `extends` para interfaces
`implements`:

``` php
class claseD extends claseC { ...
```

La interface tiene también su declaración en versión PHP:

``` php
interface Persona {
  function getName ();
}
class Pepe implements Persona {
    function getName () {
        return __CLASS__;
    }
}
```

Podemos acceder a la clase de la que hereda llamando a `parent::metodo`,
pongamos algo así:

``` php
class claseM {
    function __construct () {
        print "A";
    }
}
class claseN extends claseM {
    function __construct () {
        parent::__construct();
        print "B";
    }
}
$obj = new claseN ();
```

Este código imprime *AB*.

### instanceof

Podemos comprobar si un objeto viene de una clase o de una clase hija de
una interface o hija de otra clase, para ello utilizamos `instanceof`.

``` php
$obj = new Pepe ();
if ($obj instanceof Persona)
    print "Yes";
```

En este ejemplo *Persona* es una interface, pero podría ser una clase.

### Operador final

En PHP también existe el operador `final`, este se puede aplicar a
clases o métodos. Si se aplica en clases hace que de estas no puedan ser
heredadas, si se aplica en métodos hace que estos no se puedan
sobreescribir:

``` php
public final function Escribe { ...
final class claseZ { ...
```

### Clases abstractas

Clases abstractas\... Son clases de las cuales se heredan y que tienen
métodos abstractos, los cuales se han de implementar por cojones. Sips.
Para indicar que una clase es abstracta se le añade `abstract` delante
de `class`; para indicar que un método es abstracto delante de
`function`, a estos no se les añade código. No puedes declarar métodos
abstractos en clases no abstractas ni instanciar clases abstractas:

``` php
abstract class claseO {
...
  abstract function foo ();
...
};
class claseP extends claseO {
  function foo() { ...
```

### Excepciones

Las controlas con los `try\catch` de toda la vida:

``` php
  try { ...} 
  catch (NullHandleException $excp) { ... }
  catch (Exception $excp) { ... }
```

La clase exception tiene esta forma:

``` php
class Exception {
    function __construct($message);
    function __construct($message, $code);
    function __construct();

    final public getMessage();
    final public getCode();
    final public getFile();
    final public getLine();
    final public getTrace();
    final public getTraceAsString();

    protected $message;
    protected $code;
    protected $file;
    protected $line;
}
```

Con esto quiero decir que puedes heredar de ella y crear tus propias
excepciones\... como siempre.

### Método \_\_toString

Ya sabes para lo que sirve, no me engañes. Se sobreescribe en las clases
y esta ya puede ser pasada como un string.

``` php
class Person {
...
    function __toString() {
        return $this->name;
    }
...
```

### Función \_\_autoload

No es un método de clase. Es una función que la puedes escribir en tu
código, esta función es llamada cuando una clase que se instancia no
está incluida con un include o un require. Recibe por parámetro una
variable con el nombre de la función:

``` php
<?php
function __autoload ($class_name) {
  require_once($class_name . '.php');
}
?>
```

\... o \...

``` php
<?php
function __autoload ($class_name) {
  require_once ($_SERVER["DOCUMENT_ROOT"] . "/classes/ $class_name.php");
}
?>
```

Puedes definir las clases en ficheros a parte e incluirlos
automáticamente de esta forma.

## Cómo\...

### Formularios

### Cookies

### Sesiones

Una sesión es un trato independiente de cada visita de los usuarios de
una página web tratándolas de forma independiente, desde que esta inicia
hasta que acaba. Esto se realiza sobre el objeto \$\_SESSION de php.\
Un ejemplo de sesiones es el carrito de la compra de los usuarios, o la
autentificación y acceso a algunas páginas (si no existe sesión o
ciertas variables es que el usuario no es correcto).\
Las acciones que debemos tener claras al utilizar las sesiones:

-   **Abrir sesión**, utilizamos la función `session_start()`. Cada
    página que utilice sesiones debe tener una llamada a session_start y
    esta función debe ser llamada antes de todo, sobretodo antes de
    enviar html.
-   **Definir variable de sesión**, utilizamos la función
    `session_register('nombre_variable')` (aunque no es obligatoria
    definirla).
-   **Definir valor de variable de sesión**, utilizamos
    `$_SESSION['nombre_variable']=valor`.
-   **Obtener el valor de una variable de sesión** accediendo a
    `$_SESSION['nombre_variable']`.
-   **Eliminar alguna variable de sesión**, utilizamos la función
    `session_unregister('nombre_variable')`
-   **Cerrar sesión**, utilizamos la función `session_destroy()`

Otras funciones que fueden sernos útiles:

-   `session_id()` que devuelve el identificador de sesión.
-   `isset($_SESSION['nombre_variable'])` indica si la variable está
    definida.
-   `session_unset()` eliminta todas las variables de sesión.
-   `session_is_registered('nombre_variable')` devuelve si la variable
    está registrada en la sesión.

Por ejemplo, tenemos el siguiente fichero a.php:

``` php
<?php
session_start();
$_SESSION['hola'] = "hello session!";
?>
<html>
<body>
Iniciando. <br></br>
<a href="b.php">ves al b!</a>
</body>
</html>
```

Y el b.php:

``` php
<?php
session_start();
?>
<html>
<body>
<?php
echo $_SESSION['hola']; 
session_destroy();
?>
asfasda
</body>
</html>
```

La cuando se haga click en el link de a.php que envia al b.php se
cargará b y se mostrará la frase. Pero si se recarga b no volverá a
salir porque se habrá destruido la sesión.

### Subir archivos

## Notas

-   En toda clase existe una constante llamada `__CLASS__`, esta
    devuelve el nombre de la clase donde se encuentra:
    `$this->name = __CLASS__;`

### Archivos

-   ![PHP CheatSheet
    (png)](/sp/php/emezeta-php-card-v0.1.png){.align-center width="75"}
-   ![PHP CheatSheet (pdf)](/sp/php/emezeta-php-card-v0.1.zip)
