# Handlebars.js

-   [Página web](http://handlebarsjs.com/)

## Uso

### Agregar a la página

Primero agregaremos el link:

``` html
<script type="text/javascript" src="/scripts/handlebars-0.9.0.pre.4.js" />
```

Segundo crearemos la plantilla:

``` html
<script id="some-template" type="text/x-handlebars-template">
  <table>
    <thead>
      <th>Username</th>
      <th>Real Name</th>
      <th>Email</th>
    </thead>
    <tbody>
      {{#users}}
        <tr>
          <td>{{username}}</td>
          <td>{{firstName}} {{lastName}}</td>
          <td>{{email}}</td>
        </tr>
      {{/users}}
    </tbody>
  </table>
</script>
```

Tercero, la compilaremos y mostraremos:

``` javascript
var source   = $("#some-template").html();
var template = Handlebars.compile(source);
var data = { users: [
    {username: "alan", firstName: "Alan", lastName: "Johnson", email: "alan@test.com" },
    {username: "allison", firstName: "Allison", lastName: "House", email: "allison@test.com" },
    {username: "ryan", firstName: "Ryan", lastName: "Carson", email: "ryan@test.com" }
  ]};
$("#content-placeholder").html(template(data));
```

## Elementos

### Condicionales

### Iteradores

Para pasar un array (*launchers* tiene un array y la plantilla acepta
*nodes*):

``` javascript
$("#nav").html(template({nodes: launchers}));
```

Para coger el primer elemento de un array:

``` html
<ul id="first_element_in_people">
{{people.1.name}}
</ul>
```

Esta es la forma de asignar un array:

``` html
<select class="span3">
{{#each configs}}
<option>{{.}}</option>
{{/each}}
</select>
```

Si tenemos algo como un array de arrays
(`log: [[1, 2, 3], [5,6,7], [8,2,4]]`) lo asignaremos:

``` html
<tbody>
  {{#each log}}
    <tr>
    {{#each this}}
      <td>{{ this }}</td>
    {{/each}}
    </tr>
  {{/each}}
</tbody>
```

Podemos indicar el índice del elemento:

``` html
{{#each array}}
  {{@index}}: {{this}}
{{/each}}
```
