# Bootstrap

Es una librería JavaScript para el desarrollo de front-ends.

-   [Página web del
    proyecto](http://twitter.github.io/bootstrap/index.html)
-   ![Bootstrap, version 2.3.2](/fw/bootstrap/bootstrap.zip)

## Inicio

### Estructura de archivos

      bootstrap/
      ├── css/
      │   ├── bootstrap.css
      │   └── bootstrap.min.css
      ├── js/
      │   ├── bootstrap.js
      │   └── bootstrap.min.js
      └── img/
          ├── glyphicons-halflings.png
          └── glyphicons-halflings-white.png

### Plantilla

``` html
<!DOCTYPE html>
<html>
  <head>
    <title>Bootstrap 101 Template</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet" media="screen">
  </head>
  <body>
    <h1>Hello, world!</h1>
    <script src="http://code.jquery.com/jquery.js"></script>
    <script src="js/bootstrap.min.js"></script>
  </body>
```

## Maquetación web

La web se dividirá en 12 posibles columnas.

### Contenedores

#### Contenedor principal

Centrado en la página:

``` html
<div class="container">
...
</div>
```

#### Estructurado

``` html
<div class="container-fluid">
  <div class="row-fluid">
    <div class="span2">
      <!--Sidebar content-->
    </div>
    <div class="span10">
      <!--Body content-->
    </div>
  </div>
</div>
```

## Menús

### Navbar

``` html
<nav class="navbar">
  <div class="navbar-inner">
    <a class="brand" href="#">Hindoor System Management</a>
    <ul class="nav">
      <li class="active"><a href="#">Nodes</a></li>
      <li><a href="#">Configs</a></li>
      <li><a href="#">Stats</a></li>
    </ul>
  </div>
</nav>
```

Podemos usar el estilo `navbar navbar-inverse`.\
![](/fw/bootstrap/navbar.png){width="100"}![](/fw/bootstrap/navbar-inverse.png){width="100"}\

### Sidebar

``` html
<ul class="nav nav-list affix">
  <li><a href="#">Observers</a></li>
  <li><a href="#">Delegates</a></li>
  <li><a href="#">Starters</a></li>
  <ul class="nav nav-list affix">
    <li><a href="#">192.168.1.125</a></li>
    <li><a href="#">192.168.1.126</a></li>
    <li class="active"><a href="#">192.168.1.127</a></li>
    <li><a href="#">192.168.1.140</a></li>
    <li><a href="#">192.168.1.225</a></li>
    <li><a href="#">192.168.1.235</a></li>
    <li><a href="#">192.168.1.236</a></li>
  </ul>
</ul>
```

![](/fw/bootstrap/sidebar.png){width="100"}

#### Separador

``` html
<li class="divider"></li>
```

## Tablas

``` html
<table class="table table-hover">
  <col width="50">
  <thead>
    <tr>
      <th > </th>
      <th>Host</th>
      <th>Configuration</th>
    </tr>
  </thead>
  <tbody>
    <tr style="cursor:pointer;">
      <td><i class="icon-off"></i></td>
      <td>192.168.145.200:454</td>
      <td><span class="label label-info">CSS-01</span></td>
    </tr>
    <tr style="cursor:pointer;">
      <td><i class="icon-off"></i></td>
      <td>192.168.145.44:1454</td>
      <td><span class="label label-info">CSS-05</span></td>
    </tr>
    <tr style="cursor:pointer;">
      <td><i class="icon-off"></i></td>
      <td>192.168.45.44:7884</td>
      <td><span class="label label-info">RFactor</span></td>
    </tr>
  </tbody>
</table>
```

![](/fw/bootstrap/tabla.png){width="100"}

## Notas

### Recursos

-   [Repositorio de iconos](http://fortawesome.github.io/Font-Awesome/)
-   [Generador de estilos](http://stylebootstrap.info/)
-   [Temas bootstrap gratuitos](http://bootswatch.com/)
-   [Temas bootstrap de pago](https://wrapbootstrap.com/)
