# Sistemas Linux Xtra

## Usuarios y permisos

### Gestión de usuarios

#### Administración de usuarios

-   **adduser usuario** Como root añade un usario al sistema
    preguntandote sus características. Puedes crear un usuario sin
    necesidad de que te vaya preguntando sus características con
    **useradd**.
    -   -d Directorio personal
    -   -s Shell
    -   -p Password
    -   -g Grupo principal
    -   -G Otros grupos
    -   -m Crear el directorio personal ahora (si no cuando inicie)
-   **usermod usuario** Con los mismos parámetros que useradd puedes
    modificar un usuario.
-   **userdel usuario** Elimina un usuario.
-   **passwd** Cambia la contraseña del usuario actual.
-   **passwd usuario** Como root, cambia la contraseña del usuario.
-   **id usuario** Devuelve información de los identificadores de
    usuario\\grupo del indicado (gid, uid\...).
-   **chsh** Cambia de shell con el que inicia un usuario
-   Listar usuarios del sistema:

```{=html}
<!-- -->
```
    cat /etc/passwd | cut -d: -f1

#### Administración de grupos

-   **groupadd grupo** Añade un grupo al sistema
-   **groupdel grupo** Elimina un grupo del sistema
-   **adduser user group** Añade un suario a un grupo
-   **usermod -g grupo usuario** Cambia el grupo por defecto del
    usuario.
-   **usermod -a -G lista_de_grupos usuario** Añade el usuario a un a un
    grupo.
-   **groups user** Lista los grupos a los que pertenece el usuario.
-   Listar grupos del sistema:

```{=html}
<!-- -->
```
    cat /etc/group |cut -d: -f1 | sort

#### Ficheros

-   **/etc/passwd** Donde se guarda la info de los usuarios del sistema.
-   **/etc/shadows** Donde se guardan los passwords.
-   **/etc/group** Donde se guarda la relación grupos-usuarios.
-   **/etc/shel.** Directorio que se copia en la home del usuario al
    crearse esta.
-   **/etc/shells** Donde se encuentran todos los shells que pueden ser
    asignados a un usuario.

#### Notas

-   Para crear un usuario sin shell ni directorio:

```{=html}
<!-- -->
```
    adduser smbadmin --shell /sbin/nologin --no-create-home

### Gestión de permisos

Comandos:

-   **chown usuario fichero\\directorio** Cambia de propietario el
    fichero o directorio
    -   -R para un árbol de directorios
    -   **chown -R usuario:grupo fichero** Cambia de propietario y grupo
        el fichero o directorio
-   **chgrup grupo fichero\\directorio** Cambia de grupo el fichero o
    directorio. Con los mismos parámetros que `chown`.
-   **chmod modo fichero\\directorio** Cambia los permisos de un
    fichero\\directorio
    -   -r Hace el cambio para todo el árbol de directorios
    -   El *modo* se refiere a qué permisos se darán; generalmente se
        dan de forma octal, 3 números octales del 0 al 7. Uno de estos
        tres números es como un binario del 000 (0) al 111 (7), es
        decir, que contiene tres 1\\0 dentro, estos 1s o 0s significan
        activo\\inactivo, el primero es de lectura, segundo de escritura
        y tercero de ejecución. Y estos octales se dan (primero)
        usuario, (segundo) grupo, (tercero) otros.
    -   El *modo* también puede indicarse cómo +r, +w, +x o -r, -w, -x,
        si se quiere (+) dar (lectura, escritura o ejecución) o quitar
        (-).

```{=html}
<!-- -->
```
    chmod 777 fichero -> dá todos los permisos al fichero (111 111 111)
    chmod 700 fichero -> dá todos los permisos al usuario, a los demás nada (111 000 000)
    chmod 760 fichero -> dá todos los permisos al usuario, al grupo todos excepto ejecución y ninguno a los demás (111 110 000)
    chmod 655 fichero -> dá todos los permisos al usuario excepto el de ejecución, al grupo y a los demás permite leer y ejecutar.

### Comando sudo

**sudo** es un comando que permite a los usuarios independientemente
administrar la máquina cual root se tratase. Su sintaxis es *sudo
comando*; en el archivo */etc/sudoers* encontramos su configuración, que
se basa en indicar qué usuarios pueden hacer qué cosas (puede ser
configurado mediante el comando *visudo*).

#### /etc/sudoers

-   Sintaxis: **\[usuarios\|grupos\] \[Nombre de servidor\]= comandos**
-   Tanto los comandos como los usuarios van separados por comas. (Para
    indicar nombres de grupo pondremos antes un %, por ejemplo: %users).
-   Podemos cambiar tanto usuarios, grupos, comandos por `ALL`, que
    significan que son todos los usuarios del sistema o todos los
    comandos.
-   Si quieres seguir en otra línea, deberás acabar esa línea con \\.
-   `NOPASSWD :` delante de los comandos indica que no tendrá que
    introducir el password del root.

Ejemplos

    peter, %operator ALL= /sbin/, /usr/sbin, /usr/local/apps/check.pl
    %operator ALL= NOPASSWD: /sbin/
    ALL ALL=NOPASSWD: ALL

-   El primer ejemplo permite a `peter` y a los usuarios del grupo
    `operator` (en todos los servidores) ejecutar con sudo los comandos
    de: `/sbin/, /usr/sbin, /usr/local/apps/check.pl`
-   El segundo a los usuarios del grupo operator en todos los servidores
    y sin necesidad de introducir el password los comandos de /sbin
-   El tercero tal vez sea
    `la peor idea de la larga y triste historia de las malas ideas`.

#### Notas

-   Un `grep sudo /var/log/messages` te permitirá ver los comandos
    ejecutados con sudo
-   Si queremos conectar como `su` a partir de `sudo` haremos:
    `sudo su`.

#### Artículo

    Remember, you must use the visudo command to edit the /etc/sudoers file.

    It's tempting, and simpler, to give trusted users full access with sudo and allow them to execute any command as any user. Fight that temptation, because you want to limit access to the bare minimum whenever possible.
        * Restrict account switching: If at all possible, do not configure sudo to allow users to switch to another account. Instead, try to configure sudo to allow users to run specific commands as the users they need to operate as. For instance, there's a need for the user to install software, allow them to run RPM or APT as root without switching to the root user.
        * Don't use ALL: One of the most common mistakes is to grant ALL -- access to all commands, access to all users, or any other permutation. It can be time-consuming to lock down the access, but it's well worth the trouble.
        * Split sudoers: If you have many systems to manage and don't want to copy the same /etc/sudoers file to all systems, you can break down the sudoers file into chunks and call include files with specific sudo configurations. So, for example, if you want to include the same set of directives for managing Apache and MySQL, you can break that into a separate sudo.mysql file and use an include directive to call it from the main sudoers file.
        * Make use of groups: If possible, delegate authority by groups rather than individual users. For instance, have an admin group that has administrative privileges for managing packages and updates. This way, it's not necessary to edit sudoers each time you add or remove a new user -- simply ensure that users are appropriately managed and added/removed from the admin group.
        * Timeout: Make sure that you have an appropriate timeout set. Too short, and users are going to be frustrated rather quickly. A good rule of thumb is about five minutes.
        * Follow the right path: Lock down the path for binaries by specifying a secure_path directive in sudo -- ensuring that users can't execute commands outside the secure_path.
        * Log to a separate file: By default, sudo may log to a common messages logfile along with other system messages. This is an acceptable setup for single user systems like an Ubuntu desktop, but not so terrific for servers. Configure sudo so that it has its own logfile for easy visibility into the use of sudo and activities of the sudoers. 

## Instalación de software

### apt

apt es un sistema de las distribuciones Debian para administrar los
paquetes de instalación (.deb). Su sintaxis es la siguiente:\
**apt\[-get\|-cache\...\]** *\<opción\> \<paquete\>*

-   Instalar: `apt-get install paquete`
-   Desinstalar: `apt-get remove paquete`
-   Desinstalación total (hasta archivos de configuración):
    `apt-get --purge remove paquete` (*fíjate: - - purge*)
-   Sobreescribir: `apt-get install --reinstall paquete`
-   Actualización: `apt-get upgrade paquete`
-   Acutalización del sistema: `apt-get upgrade` y
    `apt-get dist-upgrade`
-   Reparar\\finalizar instalaciones inacabadas: `apt-get -f install`

Para buscar paquetes de instalación o inspeccionar sus características:

-   Buscar: `apt-cache search paquete`
-   Detalles: `apt-cache show paquete`

En cuanto a la caché podemos\...

-   Eliminar en la caché los registros que no se utilizarán más:
    `apt-cache autoclean`
-   Limpiar: `apt-cache clean`

#### sources.list

apt utiliza el fichero `/etc/apt/sources.list` para almacenar las
direcciones de los repositorios de paquetes donde encuentra el software
para instalar y, a la vez, le permite resolver las dependencias para
instalarlo.\
Cada una de las direcciones apuntan a una carpeta donde existe un
archivo *override* (un indice de los archivos). Por ejemplo:

    deb http://192.168.1.2:468/debian/disk1/ sarge contrib

Una vez editado este archivo deberemos hacer un `apt-get update` para
actualizar la caché de instalables registrados. Luego podríamos hacer
`apt-get -u upgrade` y `apt-get -u dist-upgrade` para actualizar el
sistema.

#### dpkg

Es una herramienta que nos ayuda en la gestión de paquetes (archivos
.deb):

-   Listar paquetes instalados: `dpkg -l`
-   Instalar: `dpkg -i paquete`
-   Eliminar: `dpkg -r paquete`
-   Eliminar (todo, hasta archivos de configuración):
    `dpkg --purge paquete` (*fíjate, es: - - purge*)
-   Ver qué archivos corresponden a un paquete: `dpkg -S paquete`
-   Volver a lanzar la aplicación de configuración:
    `dpkg-reconfigure paquete`

#### Otras herramientas

-   **aptitude** es un programa que, de forma más avanzada, también
    gestiona los archivos instalados.
-   **alien** es un programa que convierte un archivo .rpm o .tgz a .deb
    -   *alien -d fichero*
    -   *alien -i fichero* - Lo convierte y lo instala.
-   **apt-rdepends**: Muestra el arbol de dependencias de un paquete.
-   **gdebi**: Instala un archivo .deb de la forma más sencilla.

### RPM

-   Instalar: `rpm -i file.rpm`
-   Hacer un test sin llegar a instalar: `rpm -i -test file.rpm`
-   Actualizar: `rpm -U file.rpm`
-   Eliminar: `rpm -e programa`
-   Mostrar información de las acciones que se hacen: Añade el parámetro
    `-v` al comando `rpm`.
-   Ver versión instalada: `rpm -q programa`
-   Listar los ficheros instalados: `rpm -qa programa`
-   Listar los ficheros de ayuda: `rpm -ql programa`
-   Ver los archivos de configuración: `rpm -qc programa`
-   Listar todos los programas instalados: `rpm -qa`
-   Mostrar información de un programa: `rpm -qi programa`
-   Ver los últimos instalados: `rpm -qa --last` o `rpm -qa --last|head`

### Desde el código fuente

-   Necesitarás tener instaladas herramientas para compilar,
    descomprimir, configurar\... tales como:
    -   *GNU coreutils, GNU binutils, gcc, GNU tar, gunzip, bunzip2 o
        make*.
-   Lo mejor a la hora de instalar un programa a partir de su código
    fuente es seguir los pasos del fichero `README` (o `install`) que
    vendrá en la raíz del archivo descargado una vez descomprimido.

## Configuración de red

### Configuración actual

#### ifconfig

El comando `ifconfig -a` nos dará información de las tarjetas
instaladas, la ip que tienen asignada, las IRQs que utilizan, sus
puertas de enlace\...\
Este comando también nos permite cambiar la ip e indicar una estática:
*ifconfig \<interface de red\> \<ip\> netmask \<mascara\> up*.

    ifconfig eth0 10.0.0.1 netmask 255.255.255.0 up

#### Subir y bajar el servicio

`ifup eth0` y `ifdown eth0`, activan y desactivan (respectivamente) la
interface eth0.

#### Agregar gateways (puertas de enlace)

    route add default gw <ip> <interfaz de red>
    route add default gw 192.168.1.1 eth0

### Dispositivos de red

El nombre de la interfaz de red (por ejemplo `eth0`) se asigna en
mediante el mecanismo `udev`.\
\
Para que cada interfaz de red tenga siempre el mismo nombre se
registrará cada MAC y el nombre correspondiente cada vez que se
encuentre uno nuevo. Esto se guarda en
`/etc/udev/rules.d/70-persistent-net.rules`.Esto se guarda en
`/etc/udev/rules.d/70-persistent-net.rules`, un ejemplo de línea de este
sería la siguiente (para agregar un comentario añadiríamos un `#` al
principio de la línea):

    SUBSYSTEM=="net", ACTION=="add", DRIVERS=="?*", ATTR{address}=="08:00:27:fb:a1:3a", ATTR{dev_id}=="0x0", ATTR{type}=="1", KERNEL=="eth*", NAME="eth0"

Si quisiesemos reemplazar una tarjeta de red simplemente tendríamos que
editar el fichero `/etc/udev/rules.d/70-persistent-net.rules`
manteniendo cada regla en una sola línea y la MAC en minusculas
indicando que el anterior nombre de interfaz lo tiene la nueva. Este
fichero se genera a partir del programa `/lib/udev/write_net_rules` y
del fichero `persistent-net-generator.rules`.

### Ficheros

#### /etc/hosts

Este archivo enlaza IPs con nombres de máquina. Por ejemplo si queremos
hacer un ping a \"winPC\" pondremos: \<ip\> winPC. Por ejemplo, en mi
actual linux tengo:

    127.0.0.1       localhost.localdomain   localhost       arturito

De esa forma, cuando voy a localhost o a arturito (por http, ping,
telnet\...) me lo reconoce como la máquina propia (127.0.0.1 - También
llamada interface `loopback`).

#### /etc/network/interfaces

Este fichero únicamente existe en distribuciones Debian\\Ubuntu.
Corresponde a la configuración principal para estas distribuciones de
las interfaces de red. Se divide en las siguientes \"stanzas\",
apartados:

-   **auto**: Interfaces que se inicializarán cuando se inicialice el
    sistema

```{=html}
<!-- -->
```
    auto eth0

-   **mapping**: \[Mapea la red según un script\]
-   **iface**: Se definen las características de una interface. Para
    ello se usa la siguiente sintaxis: *iface \<interface\>
    \<protocolo\> \<tipo de direccionamiento\> \[características\]*
    Donde:
    -   Interface corresponde al nombre (eth0, eth1, wlan0\...)
    -   Protocolo es *inet* si hablamos de una IP normal, *inet6* si es
        IPv6 o *ipx* para IPX.
    -   El tipo de redireccionamiento: *static* (estático) o *dhcp* (por
        dhcp)
    -   Las características se refieren a las direcciones de los
        distintos elementos: *address*, *netmask*, *network*,
        *broadcast*, *gateway*, *dns-nameservers*.

Ejemplo para red TCP/IP dada por DHCP:

    auto eth0
    iface eth0 inet dhcp

Ejemplo para una interface con ip estática:

    auto eth1
    iface eth1 inet static
            address 216.10.119.240
            netmask 255.255.255.224
            network 216.10.119.224
            broadcast 216.10.119.255
            gateway 216.10.119.241
            dns-nameservers 216.10.119.241

#### Configuración DNS

En algunas distribuciones el parámetro `dns-nameservers` no funciona, es
entonces cuando debemos acceder al fichero `/etc/resolv.conf` e
introducir ahí los servidores DNS. El siguiente ejemplo configura dos
servidores DNS:

    nameserver 192.168.3.1
    nameserver 192.168.3.2

#### /etc/inetd.conf

Es el fichero de configuración de servicios de red

## Programar tareas

### atd

Utilizado para que, en un instante concreto, se lance una instrucción.

### Cron

CRON es el daemon (crond) usado para lanzar acciones de forma
cronológica.\
El archivo de configuración del cron del sistema se encuentra en
*/etc/crontab*. Además cada usuario del sistema puede tener un fichero
de configuración propio, si fuese así estaría en */var/spool/cron*, esto
se configura en los archivos */etc/cron.allow* y */etc/cron.deny*, si
existe cron.allow los usuarios que estén incluidos en él SI tendrán su
archivo de configuración, en cambio, si existe cron.deny, los usuarios
incluidos en él NO lo podrán tener. Estos archivos no están pensados
para que se editen directamente sino que hay que utilizar el comando
**crontab**:

-   `crontab [ -u usuario ] fichero` indica qué fichero especifica
    cuando se realiza la acción.
-   `crontab [ -u usuario ] { -l | -r | -e }`, las diferentes opciones
    que se pueden realizar sobre el fichero.

El usuario root puede lanzar la orden *crontab -u usuario* y así
modificar los valores del archivo de configuración del usuario
escogido.\
El parámetro `-e` crea\\edita un archivo de configuración; el `-r`
elimina el registro del archivo escogido; `-l`, en cambio, muestra dicho
archivo.\
\

#### Configuración

Configuramos CRON a partir de indicar un archivo de texto, una vez lo
tengamos creado se utilizará el comando `crontab <archivo>` para
registrarlo. El formato de dicho archivo es de 6 columnas las cuales
significan:

1.  `[Número], el minuto [0-59]`
2.  `[Número], la hora [0-23]`
3.  `[Número], el día del mes [1-31]`
4.  `[Número], el mes [1-12]`
5.  `[Número], el día de la semana [0-7] (El 0 y el 7 son el domingo)`
6.  `[Ruta], la dirección del script que se ejecutará`

Los valores que aceptan estas columnas son:

-   Un valor fijo. Para indicar el momento concreto.
-   Una lista de valores separados por comas.
-   Un rango, dos números separados por un guión.
-   Un \*, que significa \"todos los posibles\".
-   Un valor `*/num`, que viene a indicar \"cada x tiempo\".

```{=html}
<!-- -->
```
    0 0 * * *       <script> # Ejecutado a las 12 de cada día
    30 6 */2 * *    <script> # Cada dos días a las 12:30
    */10 * * * 1    <script> # Cada lunes cada 10 minutos
    0 * * * 1-5     <script> # De lunes a viernes, a la hora en punto
    0 2 1 * * /var/bckscripts/bckwapps_m > /var/bckscripts/m_wapps.log # Cada primer dia de mes a las 2 de la mañana, la salida del script se guardará en un archivo

#### Momentos predeterminados

Existen carpetas que ejecutan los archivos ejecutables que contienen
cada x tiempo:

-   */etc/cron.hourly* (cada hora).
-   */etc/cron.dail* (cada día).
-   */etc/cron.weekly* (cada semana).
-   */etc/cron.monthly* (cada mes).

#### Notas

Para cambiar el editor por defecto del `crontab -e` haremos:

    export EDITOR=vi 

## Compartir en red

### Samba

-   Aún existe una [versión antigua](/sistema/linux/howto#samba) de este
    apartado.

Samba sirve para compartir y acceder a recursos mediante el protocolo
que utiliza Windows.

#### Configuración de un server

El **smb.conf** se divide en las siguientes secciones:

-   Global Settings
-   Debugging/Accounting
-   Authentication
-   Printing
-   File sharing
-   Misc
-   Share Definitions

#### Herramienta SWAT

Permite, mediante un entorno web, administrar las opciones de Samba.
Para instalarlo haremos:

    apt-get install swat

Y para acceder a él, simplemente desde el navegador a la IP de la
máquina que lo tiene instalado por el puerto 901. Si el usuario no tiene
permisos de administración de Samba (capacidad para leer y escribir el
fichero `smb.conf`) no podrá ver las opciones más relevantes (como, por
ejemplo, `shares`).

#### Ejemplo de creación de un administrador de Samba

1.  Agregar el usuario (en este caso no es necesario tener home).
2.  Cambiar el grupo del smb.conf por el del usuario.
3.  Dar permisos de escritura al `smb.conf` para el grupo.

```{=html}
<!-- -->
```
    adduser smbadmin --shell /sbin/nologin --no-create-home
    chgrp smbadmin /etc/samba/smb.conf
    chmod g+w /etc/samba/smb.conf

#### Comando smbclient

Permite acceder a los recursos compartidos de otros ordenadores.

-   Si quisiesemos ver los recursos compartidos de un host utilizaremos
    el parámetro -L: `smbclient -L //192.168.1.2`
-   Para acceder a un recurso compartido haremos
    `smbclient //192.168.1.20/Buzon`. Esto nos abrirá una shell en la
    que los comandos más comunes son `get archivo`, `put archivo` o
    `mget mascara` (dondela máscara puede ser, por ejemplo, un \*,
    recoge los archivos que coinciden con ella).

#### Otros comandos

-   **smbstatus** es un programa que te reporta el estado de las
    conexiones samba actuales.
-   **testparm** es un programa que valida la sintaxis del fichero de
    configuración de samba.
-   **smbpasswd** programa para enlazar usuarios\\contraseñas del
    sistema samba. (`smbpasswd -a usuario`). El usuario será creado para
    samba y debe existir en windows (o en el sistema cliente).

#### Notas

-   Para utilizar nombres de máquina en vez de ip\'s (smbclient -L
    //alfredsp4) ha de existir el archivo /etc/samba/lmhosts y en él una
    referencia como la siguiente:

```{=html}
<!-- -->
```
    192.168.1.2 alfredsp4

### Sistemas de ficheros NFS

Un sistema servidor de ficheros NFS actúa sirviendo carpetas a los
clientes de forma que estos puedan montarlas fácilmente en su sistema de
archivos.\

#### Configuración básica de un servidor

En un servidor debemos **instalar el paquete** `nfs-kernel-server`:

    sudo apt-get install nfs-kernel-server

A partir de ahí debemos de de indicar\*\* qué carpetas compartimo\*\*s y
con qué permisos. Para ello iremos al archivo `/etc/exports` y
agregaremos línias como la siguiente:

    /home  *(ro,sync,no_root_squash)

Donde `/home` es la ruta de la carpeta que permitimos, el \*
[corresponde a la IP](#nomenclatura) permitida y lo que hay entre
paréntesis a los permisos. Cada cambio que hagamos en este fichero
deberá ser precedido de un reinicio del servicio:

    sudo /etc/init.d/nfs-kernel-server restart

#### Configuración básica de un cliente

Para que un cliente pueda acceder a un servidor NFS deberá tener
instalado el paquete `nfs-common`.

    sudo apt-get install nfs-common

A partir de entonces podrá montar las particiones utilizando la
siguiente nomenclatura: *IP:CARPETA*, por ejemplo, para la anterior:
`192.168.1.10:/home`, o `192.168.1.10:/media/usb0/apps`. Así es como lo
podemos usar tanto en el comando **mount**

    sudo mount example.hostname.com:/ubuntu /local/ubuntu

como en el fstab:

    example.hostname.com:/ubuntu /local/ubuntu nfs rsize=8192,wsize=8192,timeo=14,intr

:!: Es importante entender que tenemos que montar la misma ruta que
tenemos en el `/etc/exports`.
