# Sistemas Linux

## Comandos

### Ayuda

-   El paquete `man2html` te instala una visualización del man desde el
    navegador web. Para acceder a esta:
    *http://host/cgi-bin/man/man2html*.

### Sistema de archivos

-   Con `ls -lah` veremos una lista de los documentos en un directorio.
-   Con `du -sh` podremos ver el tamaño del directorio.
-   Con `df -h` puedes ver el tamaño total de las particiones montadas y
    el espacio libre. Otros parámetros como `-m` lo devolverían en
    megas.

### Trabajar en background

-   Iniciciar un comando en background: `comando &`.
-   Pondremos el proceso actual en background apretando `control + z`
-   Poner un proceso en background: `bg numeroJob`
-   Veremos los procesos actuales con: `jobs`
-   Retomaremos un proceso con `fg numeroDeJob`
-   Eliminar un proceso:
    -   `kill -9 %numeroJob`
    -   `kill -9 numeroPID`
    -   `pkill -9 -f my_pattern`, a partir de un patrón.

#### Desde consola GUI

Podemos lanzar un proceso con la consola de la GUI del sistema y que
este quede desconectado de ella de varias formas:

    $ setsid gnome-calculator   # setid desconecta de la terminal una vez esta se cierra
    $ gnome-calculator & disown # <comando> & disown 
    $ (gnome-calculator &)      # (<comando> &)
    $ nohub gnome-calculator

### Red

-   Ver configuarción actual: `ip addr`
-   Ver la routing table: `netstat -nr`
-   Ver conexiones activas:
    -   Sólo conexiones activas: `netstat`
    -   Sin resolver nombres de red: `netstat -n`
    -   Sólo las tcp: `netstat -nt`

### Hardware

-   Detectar hardware en el bus PCI: `lspci`, podemos añadirle el
    parámetro: `-v` o `-vv`, según el nivel de detalle que deseemos.
-   Ver el hardware conectado por USB: `lsusb`
-   Listado del hardware detectado por el kernel: `dmesg`
-   Listado del hardware con respecto a la cpu: `dmesg | grep -i cpu`;
    memoria: `dmesg | grep -i memory`; usb: `dmesg | grep -i usb`\...
-   Estado actual de los dispositivos; cada dispositivo es controlado
    por un proceso, y cada proceso registrado en `/proc`. Podemos
    consultar los estados haciendo: `cat /proc/fichero`, como por
    ejemplo el de la memoria: `cat /proc/meminfo` o el de la cpu
    `cat /proc/kcore`. Existen también en /proc:
    `cpuinfo, interrupts, version` o `filesystems`.
-   Saber cuanto tiempo lleva el sistema funcionando: `uptime`.

#### Discos duros y particiones

-   Información de las particiones: `fdisk -l`
-   Información de un disco concreto: `fdisk -l /dev/hda`
-   Ver el estado de un disco: `hdparm -C /dev/sdd`
-   Poner un disco en modo sleep: `hdparm -Y /dev/sdd`

#### Impresoras

-   Ver las impresoras activas: `lpstat -p -d`
-   Otra forma de ver información sobre impresoras: `cat /etc/printcap`

Enviar a imprimir:

-   Imprimir la salida de un comando: `comando | lpr`
-   Utilizar una impresora de red: `comando | lpr -P impresora`

#### CPU

-   `acpi -t` devuelve la temperatura (es necesario tener instalado el
    paquete \'acpi\')

### Procesos

-   `top` muestra por consola un gestor de recursos con los procesos más
    significativos.

### Herramientas para archivos

-   `grep -r *imbing ./*` buscará palabras que acaben con \"imbing\"
    dentro de todos los archivos del directorio actual y entrando en los
    subdirectorios.
-   `sed 's/old_string/new_string/g' file.txt > new_file.txt` , coge
    file.txt y sustituye \"old_string\" por \"new_string\" volcando el
    contenido en new_file.txt.
-   `cat file` muestra el contenido de un fichero.
-   `tac file` muestra el contenido de un fichero en orden inverso.
-   `tail file` muestra las últimas líneas de un fichero.
-   `head file` muestra las primeras líneas de un fichero.

### Comprimir y empaquetar

#### tar

    tar cvf archivo.tar archivos_seleccionados          Comprime
    tar tvf archivo.tar                     Ve el contenido
    tar xvf archivo.tar                     Descomprime

#### gzip

    gzip archivo                            Comprime el archivo
    gunzip archivo.gz                       Descomprime el archivo

#### Archivos tar.gz

    tar czvf archivo.tar.gz archivos_seleccionados          Comprime
    tar tzvf archivo.tar.gz                     Ve el contenido
    tar xzvf archivo.tar.gz                     Descomprime

#### bzip2

    bzip2 archivo                           Comprime
    bunzip2 archivo.bz2                     Descomprime

#### Archivos tbz2

    tar cvfj archivo.tbz2 archivos_seleccionados            Comprime
    tar tvfj archivo.tbz2                       Ve el contenido
    tar xvfj archivo.tbz2                       Descomprime

#### zip

-   Para crear archivos .zip utilizaremos el comando `zip*`.
-   Para descomprimirlo utilizaremos `unzip`.

### Variables de entorno

-   Ver las variables definidas: `env`
-   Definir variable (bash): `export JAVA_HOME="/usr/bin"`
-   Definir variable (tcsh): `setenv JAVA_HOME /usr/bin`
-   Ver una variable: `echo $JAVA_HOME`
-   Para eliminar una variable: `export JAVA_HOME=`

### Kernel

#### Mensajes del kernel

-   El comando `dmesg` devuelve los últimos mensajes generados por el
    kernel (por el ejemplo los que se generan al iniciarse la máquina de
    detección de hardware, al insertar un pen\...). Para verlos haremos:
    -   `dmesg | grep -i usb`: Para ver los relacionados con los puertos
        usb.
    -   `dmesg | grep -i memory`: Para ver los relacionados con la
        memoria.
    -   `dmesg | grep -i cpu`: Para ver los relacionados con el
        procesador.
    -   `dmesg | grep -i tty`, `dmesg | grep -i scsi`\...
-   `dmesg -c` limpiará los mensajes.

## Shell

### Uso de la consola

-   `Cursor arriba` muestra el anterior comando.
-   `$ history` muestra los comandos ejecutados.
-   `!<num>` ejecutará el número del history indicado.
-   `Ctrl+R` hará una busqueda hacia atrás de una porción cada vez que
    pulses dicha combinación.
-   `!<letras>` ejecuta el anterior comando que inicie por esas letras.

### Nociones

-   Los ficheros que su nombre empiece por punto serán ocultos.

### Wildcards

    $ ls com*                   # lista todos los ficheros que empiezan por com
    $ ls *.txt                  # lista todos los ficheros con extensión .txt
    $ cp file22.{txt,backup}            # Copia "file22.txt" a "file22.backup"
    $ cat {file1,file2,file3} > combined_file   # Concatena los ficheros file1, file2, y file3 en combined_file
    $ echo {a..z}                   # a b c d e f g h i j k l m n o p q r s t u v w x y z
    $ echo {0..3}                   # 0 1 2 3
    $ touch bck{1..3}.tar               # Crea los ficheros bck1.tar, bck2.tar y bck3.tar
    $ rm *[!cehg]                   # Elimina todos los ficheros que no acaben en c, e, h o g
    $ ls ?erro.txt                  # lista todos los ficheros que tienen un carácter antes de 'erro.txt'

## Comandos avanzados

### find

Para encontrar un fichero a partir de un nombre utilizaríamos la
siguiente estructura: `find [ruta] -name nombre`. Por ejemplo, para
buscar en el directorio actual (y en sus subdirectorios) el fichero que
contenga *mule*:

    find -name *mule*

Aunque también podríamos indicar que busque hasta una profundidad de
directorios con `-maxdepth num`:

    find wordpress -maxdepth 1 -name '*js'

También podemos buscar por tamaño a partir del parámetro `-size` seguido
de tamaño elegido (por ejemplo bloques (b), gigas (G)\...), podríamos
también utilizar `+` o `-` para indicar mayor o menor respectivamente.
Por ejemplo para buscar los archivos menores de 100k lanazaremos:

    find -size -100k

También podríamos buscar archivos vacíos con el parámetro `-empty`.\
Otra forma útil de buscar ficheros es a partir del usuario. Para buscar
ficheros de usuarios que ya no existan en el sistema (porque, por
ejemplo, hayan sido borrados) utilizamos el parámetro `-nouser`:

    find -nouser

Podemos buscar también a partir de los nombres de usuario con `-user` o
`-uid`. Existe el parámetro `-o` que te permite decir, por ejemplo, que
sean del usuario A o del B:

    find -user root -o -user www-data

También existe el parámetro `-not`, para indicar que buscas los que no
pertenezcan a ese usuario:

    find -not -user www-data
    find -user www-data -not -size +100k

Otro parámetro útil sería `-group` (para buscar por grupo).\
Podemos indicar que sólo busque ficheros a partir de `-type f`. También
existen parámetros para buscar por permisos, por ejemplo `-readable`,
`-writable` y `-executable`, o `-perm` que te busca a partir de permisos
expresados en números:

    find -type f -perm -110

Para utilizar expresiones regulares utilizamos el parámetro `-regex`,
debido a que hay distintos tipos de expresiones podremos combinarlo con
`-regextype` (`-regextype posix-egrep`, o `-regextype posix-egrep`).

    find -regextype posix-egrep -regex '.*(php|js)$'

Podemos buscar según el tiempo de acceso (`-atime`), la última vez que
fue modificado (`-mtime`) o la que fue cambiado (`-ctime`). Por ejemplo
los que han sido modificados en los dos últimos días:

    find -mtime +2

O para decir hace más de dos pero menos de cinco:

    find -mtime +2 -mtime -5

Para ejecutar un comando con la salida del `find` utilizaremos `-exec`
segudio del comando donde allá donde pongamos `{}` corresponderá al
elemento de salida y con `\;` sería el final del comando. Por ejemplo
para cambiar el dueño a `www-data` de los ficheros que tengan por dueño
a `root` haremos:

    find -user root -exec chown www-data {} \;

### locate

Es un comando de búsqueda como `find`, aunque no tan flexible pero sí
que permite el indexado.\
Existen las siguientes variantes:

-   slocate, la presentación de resultados la realiza acorde a los
    permisos que tiene el usuario, para que no vea datos de otros.
-   mlocate, slocate pero sin indexación completa del disco duro, sólo
    con las diferencias.
-   rlocate, la base de datos se va realizando a tiempo real.

Parámetros:

-   `-i` ignorar mayúsculas.

#### updatedb

Es el comando para actualizar la base de datos de locate. Para lanzarlo
con `sudo updatedb`.\
La configuración de esta está en `/etc/updatedb.conf` y se realiza
utilizando \"clave = valor\" donde la clave son:

-   PRUNEFS: Una lista de tipos de sistemsas de ficheros que no han de
    ser escaneados.
-   PRUNENAMES: Una lista de nombres de directorios que no han de ser
    escaneados.
-   PRUNEPATHS: Una lista de rutas completas que no han de ser
    escaneadas.
-   PRUNE_BIND_MOUNTSFR: Valores (0, no, 1 o yes) que indican si los
    montajes bind han de ser escaneados.

```{=html}
<!-- -->
```
    PRUNE_BIND_MOUNTS="yes"
    # PRUNENAMES=".git .bzr .hg .svn"
    PRUNEPATHS="/tmp /var/spool /media"
    PRUNEFS="NFS nfs nfs4 rpc_pipefs afs binfmt_misc proc smbfs autofs iso9660 ncpfs coda devpts ftpfs devfs mfs shfs sysfs cifs lustre_lite tmpfs usbfs udf fuse.glusterfs fuse.sshfs ecryptfs fusesmb devtmpfs"

#### Notas

-   Podemos encontrar el comando en los paquetes: `findutils`,
    `mlocate`\...
-   Catfish es una interface gráfica para realizar búsquedas con `find`
    y `locate`.

### netcat

**netcat** o **nc** es un programa que te permite leer y escribir
paquetes de red mediante conexiones TCP o UDP.\
Para leer todas las opciones que permite utilizaríamos `netcat -h`, pero
sus parámetros por defecto son ip y puerto (o rango de puertos).\
Podríamos conectarnos a una máquina para escribir como si fuese telnet:

    netcat www.google.com 80
    netcat 192.168.1.20 12345

O podríamos ponernos en modo lectura:

    netcat -l 12345

### lsof

### pv

## Notas

-   Podemos hacer que la salida de un comando se vuelque sobre un
    archivo de texto haciendo `comando > archivo`. Si que el texto se
    concatene al contenido del archivo haríamos `comando >> archivo`. Si
    tuviesemos que interactuar con el comando (mediante la entrada por
    teclado) haríamos `comando | tee fichero`.

### Nomenclatura

#### Direcciones IP

Para indicar direcciones IP lo podremos hacer de la siguiente manera:

    *                  Corresponde a todas.
    192.168.1.1/24     Para indicar que serán válidos los 24 primeros bits, es decir, del 192.168.1.1 al 192.168.1.255
