# MapServer

Es un proyecto Open Source multiplataforma que al ser instalado permite
mostrar mapas dinámicos a partir de una interfaz de red, tiene soporte
en gran variedad de entornos de desarrollo (PHP, Python, Java,
.NET\...).\
Nos permite realizar peticiones a capas raster, vectoriales o de bases
de datos mediante una URL, también puede retornar imágenes de leyendas,
de barras de escala, de mapas de referecia\...\
Puede ser extendido y configurado mediante `MapScript` o plantillas, y a
la vez nos da la posibilidad de construir aplicaciones web enfocada a
mapas.

-   La documentación la encontraremos en:
    <http://mapserver.org/documentation.html>

## Puesta a punto

### Instalación

MapServer se ejecuta como un CGI en el servidor HTTP Apache. Por lo
tanto si lo instalasemos de cero en un sistema basado en Debian
podríamos utilizar los siguientes comandos:

    sudo apt-get install apache2
    sudo apt-get install cgi-mapserver mapserver-bin mapserver-doc

Para ver qué paquetes están instalados haremos:

    /usr/lib/cgi-bin/mapserv -v

Para comprobar si se ha instalado correctamente accederemos a la ruta
(por ejemplo, en Ubuntu) `cgi-bin/mapserv` (por ejemplo
`http://192.168.1.105/cgi-bin/mapserv`) y tendrá que devolver algo así
como \"*No query information to decode. QUERY_STRING is set, but
empty.*\".

### Arquitectura interna

MapServer se compone de\...

-   **MapFiles**: Archivos de texto para configurar la aplicación,
    definen el area del mapa e indican donde están los datos y como
    devolver las imágenes, también define las capas de un mapa (data
    source, proyecciones, simbología\...). Han de tener la extensión
    `.map` porque sino no serán reconocidos.
-   **Datos geográficos**: MapServer puede leer distintos tipos de datos
    (aunque por defeccto lee ESRI shapefile).
-   **Páginas HTML**.

MapServer es un programa CGI y como tal no tiene estado, cada petición
que se le hace es independiente y no es influida por las pasadas.\
![](/sistemas/gis/ms-arquitectura.png){.align-center width="500"}

## MapFiles

Los MapFiles son los archivos para configurar los mapas que sirve
MapServer, la documentación de referencia la encontraremos en
<http://mapserver.org/mapfile/index.html#mapfile>.\
Los MapFiles son archivos de texto que especifican un mapa. Están
divididos en diferentes secciones y su contenido ha de seguir las
siguientes normas:

-   Los comentarios serán indicados mediante el carácter \'#\'.
-   Serán parseados de arriba abajo, por lo tanto las layers indicadas
    al final serán dibujadas las últimas.
-   Siempre es recomendable utilizar rutas relativas y no absolutas,
    aunque son admitidas las dos.
-   Las rutas tendrán que ser indicadas entre comillas (simples o
    dobles, da igual).

### Objetos

Estos son los objetos más utilizados internamente en un MapFile y sus
propiedades:

#### MAP

-   **EXTENT**, es la extensión del mapa resultado.
-   **SIZE**, es el tamaño del mapa.
-   **IMAGECOLOR**, el color de fondo del mapa.

```{=html}
<!-- -->
```
    MAP
        NAME                 "sample"
        EXTENT        -180 -90 180 90 # Geographic
        SIZE                  800 400
        IMAGECOLOR        128 128 255
    END

#### LAYER

El parámetro **DATA** indica a qué tipo se refiere el parémetro
**SHAPEPATH** del objeto MAP, si no se definiese se tomaría como un
shapefile (.shp).

#### RASTER

    LAYER
        NAME "bathymetry"
        TYPE RASTER
        STATUS DEFAULT
        DATA "bath_mapserver.tif"
    END

#### Layers vectoriales

Estas pueden ser del tipo point, line o polygon (parámetro **TYPE**),
según lo que se quiera mostrar.

    LAYER
        NAME   "world_poly"
        DATA         'shapefile/countries_area.shp'
        STATUS       ON
        TYPE         POLYGON
        CLASS
            NAME       'The World'
            STYLE
                OUTLINECOLOR    0 0 0
            END
        END
    END # layer

#### Objetos CLASS y STYLE

Son los utilizados para dar formato a los objetos LAYER.

    CLASS
    NAME "Primary Roads"
    STYLE
        SYMBOL "circle"
        COLOR 178 114 1
        SIZE 15
    END #style1
    STYLE
        SYMBOL "circle"
        COLOR 254 161 0
        SIZE 7
    END #style2
    END

#### SYMBOLS

Se pueden definir directamente en el mapfile o en un fichero separado
(entonces deberíamos utilizar el parámetro **SYMBOLSET** en el MAP). Por
ejemplo:

    MAP
        NAME           "sample"
        EXTENT        -180 -90 180 90 # Geographic
        SIZE           800 400
        IMAGECOLOR     128 128 255
        SYMBOLSET      "../etc/symbols.txt"
    END # map
    LAYER
        ...
        CLASS
            NAME "Ski Area"
            STYLE
                SYMBOL "ski"
            END
        END
    END # layer

Y `symbols.txt` contendría:

    SYMBOL
        NAME "ski"
        TYPE PIXMAP
        IMAGE "ski.gif"
    END

#### LABEL

El objeto LAYER tiene el parámetro **LABELITEM** que puede ser utilizado
en una columna específica en unos datos para referirse a un fichero
**FONTSET** (el cual contiene una referencia a los nombres de fuentes
posibles).

    LABEL
        FONT "sans-bold"
        TYPE truetype
        SIZE 10
        POSITION LC
        PARTIALS FALSE
        COLOR  100 100 100
        OUTLINECOLOR 242 236 230
    END # label

#### INCLUDE

Cualquier parte del mapfile puede ser almacenado en un fichero por
separado y añadido mediante el parámetro **INCLUDE**, el nombre del
fichero puede tener cualquier extensión y su ruta será siempre relativa
al .map. De esa forma tanto las layers como los estilos pueden ser
incluidos en multiples aplicaciones.\
Por ejemplo, podríamos tener un fichero `shadedrelief.lay`:

    LAYER
        NAME         'shadedrelief'
        STATUS       ON
        TYPE         RASTER
        DATA         'GLOBALeb3colshade.jpg'
    END

Y el mapfile:

    MAP
        ...
        INCLUDE "shadedrelief.lay"
        ...
    END

O incluir los objetos layers a parte:

    NAME "base"
    #
    # include reference objects
    #
    INCLUDE "../templates/template.ref"
    #
    # Start of layer definitions
    #
    INCLUDE "../layers/usa/usa_outline.lay"
    INCLUDE "../layers/canada/base/1m/provinces.lay"
    INCLUDE "../layers/canada/base/1m/roads_atlas_of_canada_1m.lay"
    INCLUDE "../layers/canada/base/1m/roads_atlas_of_canada_1m_shields.lay"
    INCLUDE "../layers/canada/base/1m/populated_places.lay"
    END # Map File

## Como\...

### Crear un servicio WMS

-   [Servicios WMS](/sistemas/gis#servicios_wms)
-   [Manual de MapServer sobre cómo
    hacerlo](http://mapserver.org/ogc/wms_server.html)

Para que MapServer permita ser configurado como WMS ha de haber sido
compilado con las librerías `libcurl` y `Proj.4`, para comprobar si
realmente admite esta propiedad ejecutaremos `mapsrv -v` y tendrá que
salir `SUPPORTS=WMS_SERVER`.\

:?: También será necesario definir un objeto `METADATA` en el MAP y en
las LAYER.

## MapScript
