# Sistemas de Información Geográfica (GIS)

Es la forma de integrar datos geográficos en un ordenador (hardware +
software) para su captura, almacenaje, manipulación, análisis\... Es
decir, es una forma de aprovechar la informática para el despliegue y
uso de la geografía; por ejemplo, mediante estos sistemas se podrían
calcular tiempos de respuesta en caso de desastre natural en una zona,
analizar las tendencias de los habitantes de la población para utilizar
el transporte público\...

## Básico

### Conceptos GIS

-   **Basemap**: Mapa base sobre el cual se muestran los datos
    espaciales.
-   **Datos geoespaciales** (o simplemente espaciales), que contienen
    coordenadas y se pueden posicionar correctamente en un basemap.
-   **Layers**: Capas de un mapa que muestran los datos espaciales en la
    relación escala-detalle. Es decir, podríamos tener una layer de las
    comunidades autónomas, otra de los ríos y otra de las ciudades, a
    una escala mayor veríamos las comunidades y los ríos, a una menor
    podríamos ver los ríos y las ciudades y a una aún menor podríamos
    poner datos espaciales como por ejemplo la localización de las
    pizzerias en una layer de calles por población. Es la combinación de
    estas la que hacen rica una aplicación GIS.
-   **Datos raster**: Imágenes que han sido tomadas de forma aerea o por
    satélite, se guardan en un formato de grid (por celdas). No contiene
    datos implicitos más que los de la posición de cada celda para luego
    mostrar las imágenes en su posición correcta dentro de la capa, y
    poder mostrar así los datos de un mapa de forma \"vistosa\" y real.
-   **Datos vectoriales**: No fotográficos sino generados a partir de
    coordenadas; a partir de este tipo de datos es más sencillo realizar
    estudios. Los tipos vectoriales más significativos son el punto
    (puede representar aeropuertos, pizzerias\...), la línea (unión de
    dos puntos, puede representar carreteras, ríos, itinerarios,
    caminos\...) y los polígonos (unión de un número indeterminado de
    líneas, para representar poblaciones, fronteras, ciudades\...). Es
    más caro de mantener que los datos raster.
-   **Features**: Los elementos independientes que se muestran en el
    mapa, estos pueden contener atributos espaciales (puntos,
    línias\...) y no espaciales.
-   **OGC** (Open Geospatial Consortium): Conjunto de organizaciones que
    marcan los estándares GIS.

#### Servicios

-   **WMS** (Web Map Service), es un protocolo para pasar imágenes
    raster.
-   **WFS** (Web Feature Service), como el WMS pero que además permite
    pasar geometrías (datos vectoriales + raster).
-   **WCS** (Web Coverage Service)
-   **CSW** (Web Catalogue Service)

#### Otros

-   **DEM**: Digital Elevation Model, representación de la elevación del
    terreno.
-   **Geocoding**: Proceso de encontrar la localización de una dirección
    (calle, número) en un mapa.
-   **Geoprocessing**: Acciones para tratar los datos geográficos
    mediante herramientas específicas.
-   **Georeferencing**: El proceso de describir correctamente una
    localización de elementos mediante las coordenadas.
-   **Georeferenciación lineal** (LRS (Linear Reference System)): es una
    forma de referenciar a través de elementos lineales. Los elementos
    se localizan por un punto conocido como *milepoint* o un evento
    lineal *segmento*.
-   **Ortofoto**, foto realizada desde el aire (desde avión o satelite)
    que mediante una corrección corresponde con el mapa.
-   **WKT** (Well Known Text): Sintaxis en texto plano para describir
    los objetos espaciales.

### Diferentes formatos de ficheros

-   **Shapefiles**, formato creado por ESRI aunque ampliamente
    utilizado, está formado por tres ficheros diferentes (pero
    enlazados):
    -   El `.shp` que contiene los datos geográficos en formato
        vectorial.
    -   El `.shx` es el fichero índice, por cada registro en el .shp hay
        uno en este.
    -   El `.dbf` contiene los datos enlazados y no geoespaciales en
        formato dBASE (legible por MS Excel).
    -   Puede existir un cuarto, el `.prj` que indica la proyección del
        fichero y está escrito en WKT.
-   **GML** (Geographic Markup Language), en formato XML, abierto y
    expuesto como ficheros de texto. Sobretodo se utiliza en servicios
    web.
-   **KML** (Keyhole Markup Language) , parecido al GML ya que también
    está basado en XML, es el utilizado por Google Eart. [Entrada en la
    wiki](/tags/kml).

### Las proyecciones y los conceptos que las envuelven

Un mapa de la tierra la proyecta a partir de un eje de coordenadas
cartesianas donde la horizontal, `x`, es denominada latitud y la
vertical, `y`, se denomina **longitud**; si dividimos la esfera en
línias paralelas horizontales (**latitud**) tendremos una que la divide
en dos denominada ecuador y las demás, los **paralelos**, se numeran del
0 al 90 positivamente las que van hacia el norte y del 0 al -90 las que
van al sur. Los **meridianos** son las línias paralelas a la longitud,
estos por la forma de la tierra acaban convergiendo en los polos norte y
sur, los meridianos que van hacia el este son numerados del 0 al 180 y
los que van al oeste del 0 al -180 siendo el 0 el meridiano de
Greenwich.\

Debido a que no existe una tercera dimensión al mostrar un mapa sobre un
plano se acaba deformando dicho mapa (la unión de meridianos y paralelos
forman cuadrados perfectos) se realiza una **proyección** sobre dicho
plano de lo que se quiere mostrar intentando minimizar al máximo posible
las distorsiones (de distancia, de dirección, de forma y de área) que
puedan ocurrir. Existen varios tipos de proyecciones, aunque no por ello
hay una mejor que otra sino que cada una minimiza una distorsión
concreta, y cuando estes montando un mapa asegurate que todas las capas
utilizan la misma proyección.\

La proyección **Mercator** es la más utilizada (esencialmente es la que
utiliza en las clases y muy parecida a la de Google Maps). Se basa en un
plano cartesiano modificado brevemente, muestra la distribución del
planeta pero no hace lo correcto con las distancias.\

Otro de los problemas existentes es que la Tierra no es completamente
esférica (sino con un poco de matemáticas podríamos calcular
distancias). Podríamos decir que la forma que tiene el planeta Tierra es
de geoide (debido a que por efectos de la gravitación y de la fuerza
centrífuga producida al rotar sobre su eje se genera el aplanamiento
polar y el ensanchamiento ecuatorial). Un **DEM** (Digital Elevation
Model) es una representación digital del la superficie terrestre,
también es conocido el **DTM** (Digital Terrain Model).\
Un **datum** es un concepto que puede ser tangible (visible) o
simplemente teórico y corresponde a la zona (forma geométrica)
correspondiente al área de estudio. Por ejemplo el *North American
Datum* de 1983 (NAD83) corresponde a una forma elipsoide GRS80.\

Los **sistemas de coordenadas (o coordinate reference system (CRS))**
son la forma de posicionar los pares x,y. Existen varias formas de
expresarlos:

-   Como **grados, minutos y segundos (DMS)**. En un circulo hay 360
    grados, estos se dividen en 60 minutos y estos en 60 segundos. En la
    realidad la distancia entre grados es de 111km, la distancia entre
    minutos es de 1.85km y entre segundos de 31m. Así que para dar la
    localización concreta de a casa blanca podremos decir 38 grados, 53
    minutos, 55 segundos norte y 77 grados, 2 minutos, 16 segundos
    oeste; o en DMS: (38 53' 55", -77 2' 16").
-   **Grados decimales (DD)**. Es una conversión del anterior a decimal,
    por ejemplo, en vez de decir que la posición es 1 grado 30 minutos
    diríamos que es 1.5 grados. Algo más agradable de \"programar\". Por
    ejemplo, la posición de la casa blanca sería (38.898748,
    -77.037684). Al expresar una localización de esta forma siempre
    deberíamos utilizar 6 decimales.
-   **Metros**.
-   **UTM** (Universal Transverse Mercator). Es la proyección más
    popular, las coordenadas (x,y) se expresan en metros en vez de en
    grados dividiendo el planeta en un grid. La idea, para no caer en
    errores de distorsión, no se basa en una proyección simple sino en
    120 proyecciones distintas. Se divide el mundo en celdas de de 6
    grados de longitud de ancho, hay 60 zonas UTM northern y 60 southern
    (360 grados) siendo cada una una proyección independiente; debido a
    esta división los errores, en zonas pequeñas, son insignificantes.
    Para calcular la posición total se indica primero la celda y luego
    las coordenadas de latitud\\longitud, es decir, la casa blanca
    estaría en las coordenadas UTM (18N, 323,294 E, 4,307,514 N).

El conjunto de datum, sistema de coordenadas y proyección que
corresponden a datos espaciales se les denomina **GEOGCS** (Geographic
Coordinate System) o **GCS** si no están proyectados.

### Otros conceptos

La **escala** (el escalado) de un mapa se expresa en un ratio 1:1000, el
cual significa que 1 unidad en el mapa equivale a 1000 de esa unidad en
el suelo. Por ejemplo pongamos un mapa de 30cm por 30cm, en este se
muestra un área de 30km por 30km, entonces la escala es de 30:3.000.000
o lo que es lo mismo 1:100.000 (dividiendo las dos partes del ratio por
la parte de la izquierda), es decir 100.000cm es en realidad 1.000m o,
lo que es lo mismo, 1km. Y si en el mapa mostrasemos el doble de espacio
la escala sería 1:200.000 (un mapa de menos **resolución**).

## Geodatabases

## Servicios OGC

### Servicios WMS

O *Web Map Service*, permite a los clientes utilizar sus datos para
crear mapas configurables, estos mapas podrán enlazar datos de distintos
fuentes WMS para así crear un resultado más complejo.\
Los servidores WMS interactuan con los clientes mediante el protocolo
HTTP, definiendo las posibles peticiones que le pueden llegar a realizar
y por cada una de ellas los parámetros que admiten. La especificación
WMS indica que al menos han de permitir los dos siguientes tipos de
peticiones:

1.  **GetCapabilities** que retorna un XML con metadatos de la
    información del servidor WMS.
2.  **GetMap** que retorna una imágen del mapa de acuerdo a los
    parámetros indicados por el usuario.

Existen otras opcionales:

1.  **GetFeatureInfo** retorna información sobre una feature en una
    posición.
2.  **DescribeLayer** que retorna la descripción de un XML de una o más
    capas de mapas.
3.  **GetLegendGraphic** que retorna la imágen de la leyenda.

## Como\...

### Editar la proyección en los datos espaciales

Tres herramientas pueden ser usadas para ello Proj, GDAL (Geospatial
Data Abstraction Library) y GEOS, en el paquete FWTools (Frank Warmerdam
Tools) encontraremos **GDAL** y **Proj**. **GEOS** (Geometry Open
Source) permite a las aplicaciones leer y escribir elementos (tales como
puntos, línias o polígonos) en un formato WKT. **GDAL** proporciona unos
comandos para reproyectar ficheros raster, pero además contiene un
subproyecto (**OGR**) usado para reproyectar datos vectoriales.\
\
En FWTools viene un comando denominado `ogr2ogr`, este proporciona una
serie de utilidades sobre las capas con datos vectoriales. Haciendo
`ogr2ogr -h` veremos las diferenctes opciones. Una de las utilidades es
la de reproyectar una capa, por ejemplo:

    ogr2ogr -t_srs EPSG:4269 co-hw.shp highways.shp

Este comando reproyectaría la capa highways.shp en la co-hw.sph (o
alrevés :?:); el argumento `-t_srs` especifica (Target) Spatial
Reference System (SRS), aunque si el fichero .prj está presente
utilizaremos `-s_srs` (Source) SRS. EPSG:4269 corresponde a la
proyecciónEuropean Petroleum Survey Group.

## Notas

## Recursos

### Documentos

-   ![GIS en 1000 palabras](/sistemas/gis/gissoftware_steiniger2008.pdf)

### Datos geoespaciales

-   <http://www.openstreetmap.org/>, mapas opensource que se van
    completando a partir de una comunidad mundial.
-   <http://www.census.gov/geo/www/cob/index.html>, mapas de EEUU.
-   [gData](http://biogeo.berkeley.edu/bgm/gdata.php), servicio de datos
    vectoriales de todo el mundo.
-   [Terraserver](http://terraserver-usa.com/), servidor de imágenes de
    USA.

### Descarga y uso de rasters

### Software

-   [GPSBabel](http://www.gpsbabel.org/), software para convertir datos
    geoespaciales a formato leido por receptores GPS y viceversa.
-   [FWTools](http://fwtools.maptools.org/), donde encontrar la mayoría
    de las herramientas que se utilizan (`ogr2ogr`, `GDAL`\...).
-   [OGR](http://www.gdal.org/ogr/).

#### Visores y editores

-   ESRI, empresa de software privativo en la vanguardia del campo GIS.
    Un visor gratuito de datos georeferenciados es ArcExplorer.
-   GRASS: Software OpenSource de análisis y gestión de datos
    geoespaciales, procesamiento de imágenes, producción de
    mapas/gráficos, modelado espacial y visualización GIS.
-   Quantum GIS (o QGIS): Parecido a GRASS.
-   [OpenJump](http://jump-pilot.sourceforge.net/)
-   [gvSIG](http://www.gvsig.gva.es/)
-   [OpenMap](http://openmap.bbn.com/), visor en Java.
-   [Gaia](http://www.thecarbonproject.com/gaia.php), otro visor
    bastante sencillo pero efectivo.

#### Librerías

-   GDAL: Librería para la lectura\\escritura de gráficos geoespaciales
    en C++.
-   [OpenEV](http://openev.sourceforge.net/), Grupo de herramientas para
    mostrar imágenes georeferenciadas (desarrollada en Python con GDAL y
    OpenGL).
