# NodeJS

Es un lenguaje que permite ejecutar scripts JavaScript utilizando el
intérprete V8 de Google. Además añade una librería de acceso a red y
ficheros.

-   [API de NodeJS](http://nodejs.org/api)

## Básico

### Uso

Instalar:

    $ sudo apt-get update
    $ sudo apt-get install python-software-properties python g++ make
    $ sudo add-apt-repository ppa:chris-lea/node.js
    $ sudo apt-get update
    $ sudo apt-get install nodejs

Ejecutar un programa:

    $ node code.js

Primera línea a añadir si se quiere hacer ejecutable:

    #!/usr/bin/env node

Saber las versiones:

    $ node --version
    $ npm --version

Instalar módulos (localmente):

    $ npm install restler csv accounting

Para usar funciones de un fichero (o de uno de los módulos locales):

``` javascript
var mr = require('./market-research.js'); 
var csv = require('csv');
mr.marketResearch(["FB", "ORCL"]);
```

Podemos hacer una llamada al script utilizando líneas de código por
consola:

    $ node -e "var mr = require('./market-research.js'); mr.marketResearch();"

### Variables

-   `'__filename`\' devuelve el nombre del script.

## Operaciones básicas

### Consola

-   `console.log(string)`, escribir.

### Ficheros

Para escribir un string `out` en un fichero `outfile`:

``` javascript
var fs = require('fs');
fs.writeFileSync(outfile, out);  
```
